/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.Callback;
import greycat.Constants;
import greycat.Graph;
import greycat.Node;
import greycat.Query;
import greycat.base.BaseNode;
import greycat.internal.heap.HeapContainer;
import greycat.internal.heap.HeapLongLongArrayMap;
import greycat.plugin.NodeState;
import greycat.struct.LongLongArrayMapCallBack;
import greycat.struct.RelationIndexed;

class HeapRelationIndexed
extends HeapLongLongArrayMap
implements RelationIndexed {
    private final Graph _graph;

    HeapRelationIndexed(HeapContainer p_listener, Graph graph) {
        super(p_listener);
        this._graph = graph;
    }

    @Override
    public RelationIndexed add(Node node, String ... attributeNames) {
        this.internal_add_remove(true, node, attributeNames);
        return this;
    }

    @Override
    public RelationIndexed remove(Node node, String ... attributeNames) {
        this.internal_add_remove(false, node, attributeNames);
        return this;
    }

    private void internal_add_remove(boolean isIndex, Node node, String ... attributeNames) {
        Query flatQuery = node.graph().newQuery();
        NodeState toIndexNodeState = node.graph().resolver().resolveState(node);
        for (int i = 0; i < attributeNames.length; ++i) {
            String attKey = attributeNames[i];
            Object attValue = toIndexNodeState.get(attKey);
            if (attValue != null) {
                flatQuery.add(attKey, attValue.toString());
                continue;
            }
            flatQuery.add(attKey, null);
        }
        if (isIndex) {
            this.put(flatQuery.hash(), node.id());
        } else {
            this.delete(flatQuery.hash(), node.id());
        }
    }

    @Override
    public RelationIndexed clear() {
        return this;
    }

    @Override
    public void find(Callback<Node[]> callback, long world, long time, String ... params) {
        Query queryObj = this._graph.newQuery();
        queryObj.setWorld(world);
        queryObj.setTime(time);
        String previous = null;
        for (int i = 0; i < params.length; ++i) {
            if (previous != null) {
                queryObj.add(previous, params[i]);
                previous = null;
                continue;
            }
            previous = params[i];
        }
        this.findByQuery(queryObj, callback);
    }

    @Override
    public final long[] select(String ... params) {
        Query queryObj = this._graph.newQuery();
        String previous = null;
        for (int i = 0; i < params.length; ++i) {
            if (previous != null) {
                queryObj.add(previous, params[i]);
                previous = null;
                continue;
            }
            previous = params[i];
        }
        return this.selectByQuery(queryObj);
    }

    @Override
    public final long[] selectByQuery(Query query) {
        return this.get(query.hash());
    }

    @Override
    public void findByQuery(final Query query, final Callback<Node[]> callback) {
        final long[] foundIds = this.get(query.hash());
        if (foundIds == null) {
            callback.on(new BaseNode[0]);
        } else {
            this._graph.resolver().lookupAll(query.world(), query.time(), foundIds, new Callback<Node[]>(){

                @Override
                public void on(Node[] resolved) {
                    BaseNode[] resultSet = new BaseNode[foundIds.length];
                    int resultSetIndex = 0;
                    for (int i = 0; i < resultSet.length; ++i) {
                        Node resolvedNode = resolved[i];
                        if (resolvedNode == null) continue;
                        NodeState resolvedState = HeapRelationIndexed.this._graph.resolver().resolveState(resolvedNode);
                        boolean exact = true;
                        for (int j = 0; j < query.attributes().length; ++j) {
                            Object obj = resolvedState.getAt(query.attributes()[j]);
                            if (query.values()[j] == null) {
                                if (obj == null) continue;
                                exact = false;
                                break;
                            }
                            if (obj == null) {
                                exact = false;
                                break;
                            }
                            if (obj instanceof long[]) {
                                if (query.values()[j] instanceof long[]) {
                                    if (Constants.longArrayEquals((long[])query.values()[j], (long[])obj)) continue;
                                    exact = false;
                                    break;
                                }
                                exact = false;
                                break;
                            }
                            if (Constants.equals(query.values()[j].toString(), obj.toString())) continue;
                            exact = false;
                            break;
                        }
                        if (!exact) continue;
                        resultSet[resultSetIndex] = resolvedNode;
                        ++resultSetIndex;
                    }
                    if (resultSet.length == resultSetIndex) {
                        callback.on(resultSet);
                    } else {
                        BaseNode[] trimmedResultSet = new BaseNode[resultSetIndex];
                        System.arraycopy(resultSet, 0, trimmedResultSet, 0, resultSetIndex);
                        callback.on(trimmedResultSet);
                    }
                }
            });
        }
    }

    @Override
    public long getByIndex(int index) {
        return this.value(index);
    }

    @Override
    public long[] all() {
        final long[] flat = new long[this.size()];
        final int[] i = new int[]{0};
        this.each(new LongLongArrayMapCallBack(){

            @Override
            public void on(long key, long value) {
                flat[i[0]] = value;
                i[0] = i[0] + 1;
            }
        });
        return flat;
    }

    HeapRelationIndexed cloneIRelFor(HeapContainer newParent, Graph graph) {
        HeapRelationIndexed cloned = new HeapRelationIndexed(newParent, graph);
        cloned.mapSize = this.mapSize;
        cloned.capacity = this.capacity;
        if (this.keys != null) {
            long[] cloned_keys = new long[this.capacity];
            System.arraycopy(this.keys, 0, cloned_keys, 0, this.capacity);
            cloned.keys = cloned_keys;
        }
        if (this.values != null) {
            long[] cloned_values = new long[this.capacity];
            System.arraycopy(this.values, 0, cloned_values, 0, this.capacity);
            cloned.values = cloned_values;
        }
        if (this.nexts != null) {
            int[] cloned_nexts = new int[this.capacity];
            System.arraycopy(this.nexts, 0, cloned_nexts, 0, this.capacity);
            cloned.nexts = cloned_nexts;
        }
        if (this.hashs != null) {
            int[] cloned_hashs = new int[this.capacity * 2];
            System.arraycopy(this.hashs, 0, cloned_hashs, 0, this.capacity * 2);
            cloned.hashs = cloned_hashs;
        }
        return cloned;
    }
}

