/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.Container;
import greycat.Graph;
import greycat.Type;
import greycat.chunk.StateChunk;
import greycat.internal.CoreConstants;
import greycat.internal.heap.HeapChunkSpace;
import greycat.internal.heap.HeapContainer;
import greycat.internal.heap.HeapDMatrix;
import greycat.internal.heap.HeapEGraph;
import greycat.internal.heap.HeapENode;
import greycat.internal.heap.HeapLMatrix;
import greycat.internal.heap.HeapLongLongArrayMap;
import greycat.internal.heap.HeapLongLongMap;
import greycat.internal.heap.HeapRelation;
import greycat.internal.heap.HeapRelationIndexed;
import greycat.internal.heap.HeapStringIntMap;
import greycat.internal.tree.KDTree;
import greycat.internal.tree.NDTree;
import greycat.plugin.NodeStateCallback;
import greycat.struct.Buffer;
import greycat.struct.DMatrix;
import greycat.struct.EGraph;
import greycat.struct.LMatrix;
import greycat.struct.LongLongArrayMap;
import greycat.struct.LongLongArrayMapCallBack;
import greycat.struct.LongLongMap;
import greycat.struct.LongLongMapCallBack;
import greycat.struct.Relation;
import greycat.struct.RelationIndexed;
import greycat.struct.StringIntMap;
import greycat.struct.StringLongMapCallBack;
import greycat.utility.Base64;
import java.util.Arrays;

class HeapStateChunk
implements StateChunk,
HeapContainer {
    private final long _index;
    private final HeapChunkSpace _space;
    private int _capacity;
    private volatile int _size;
    private int[] _k;
    private Object[] _v;
    private byte[] _type;
    private int[] next_and_hash;
    private boolean _dirty;
    private static final byte LOAD_WAITING_ALLOC = 0;
    private static final byte LOAD_WAITING_TYPE = 1;
    private static final byte LOAD_WAITING_KEY = 2;
    private static final byte LOAD_WAITING_VALUE = 3;

    final Graph graph() {
        return this._space.graph();
    }

    HeapStateChunk(HeapChunkSpace p_space, long p_index) {
        this._space = p_space;
        this._index = p_index;
        this.next_and_hash = null;
        this._type = null;
        this._size = 0;
        this._capacity = 0;
        this._dirty = false;
    }

    @Override
    public final long world() {
        return this._space.worldByIndex(this._index);
    }

    @Override
    public final long time() {
        return this._space.timeByIndex(this._index);
    }

    @Override
    public final long id() {
        return this._space.idByIndex(this._index);
    }

    @Override
    public final byte chunkType() {
        return 0;
    }

    @Override
    public final long index() {
        return this._index;
    }

    @Override
    public final synchronized Object getAt(int p_key) {
        return this.internal_get(p_key);
    }

    private int internal_find(int p_key) {
        if (this._size == 0) {
            return -1;
        }
        if (this.next_and_hash == null) {
            for (int i = 0; i < this._size; ++i) {
                if (this._k[i] != p_key) continue;
                return i;
            }
            return -1;
        }
        int hashIndex = p_key % (this._capacity * 2);
        if (hashIndex < 0) {
            hashIndex *= -1;
        }
        int m = this.next_and_hash[this._capacity + hashIndex];
        while (m >= 0) {
            if (p_key == this._k[m]) {
                return m;
            }
            m = this.next_and_hash[m];
        }
        return -1;
    }

    private Object internal_get(int p_key) {
        Object result;
        if (this._size == 0) {
            return null;
        }
        int found = this.internal_find(p_key);
        if (found != -1 && (result = this._v[found]) != null) {
            switch (this._type[found]) {
                case 23: {
                    return new NDTree((EGraph)result);
                }
                case 22: {
                    return new KDTree((EGraph)result);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public final synchronized Container setAt(int p_elementIndex, byte p_elemType, Object p_unsafe_elem) {
        this.internal_set(p_elementIndex, p_elemType, p_unsafe_elem, true, false);
        return this;
    }

    @Override
    public Container remove(String name) {
        return this.set(name, (byte)4, null);
    }

    @Override
    public Container removeAt(int key) {
        return this.setAt(key, (byte)4, null);
    }

    @Override
    public final synchronized Container set(String key, byte p_elemType, Object p_unsafe_elem) {
        this.internal_set(this._space.graph().resolver().stringToHash(key, true), p_elemType, p_unsafe_elem, true, false);
        return this;
    }

    @Override
    public final synchronized Object get(String key) {
        return this.internal_get(this._space.graph().resolver().stringToHash(key, false));
    }

    @Override
    public final <A> A getWithDefault(String key, A defaultValue) {
        Object result = this.get(key);
        if (result == null) {
            return defaultValue;
        }
        return (A)result;
    }

    @Override
    public final <A> A getAtWithDefault(int key, A defaultValue) {
        Object result = this.getAt(key);
        if (result == null) {
            return defaultValue;
        }
        return (A)result;
    }

    @Override
    public final synchronized byte typeAt(int p_key) {
        int found_index = this.internal_find(p_key);
        if (found_index != -1) {
            return this._type[found_index];
        }
        return -1;
    }

    @Override
    public byte type(String key) {
        return this.typeAt(this._space.graph().resolver().stringToHash(key, false));
    }

    @Override
    public final synchronized Object getOrCreateAt(int p_key, byte p_type) {
        int found = this.internal_find(p_key);
        if (found != -1 && this._type[found] == p_type) {
            return this._v[found];
        }
        Object toSet = null;
        Object toGet = null;
        switch (p_type) {
            case 13: {
                toGet = toSet = new HeapRelation(this, null);
                break;
            }
            case 14: {
                toGet = toSet = new HeapRelationIndexed(this, this._space.graph());
                break;
            }
            case 15: {
                toGet = toSet = new HeapDMatrix(this, null);
                break;
            }
            case 16: {
                toGet = toSet = new HeapLMatrix(this, null);
                break;
            }
            case 12: {
                toGet = toSet = new HeapStringIntMap(this);
                break;
            }
            case 10: {
                toGet = toSet = new HeapLongLongMap(this);
                break;
            }
            case 11: {
                toGet = toSet = new HeapLongLongArrayMap(this);
                break;
            }
            case 17: {
                toGet = toSet = new HeapEGraph(this, null, this._space.graph());
                break;
            }
            case 22: {
                HeapEGraph tempKD = new HeapEGraph(this, null, this._space.graph());
                toSet = tempKD;
                toGet = new KDTree(tempKD);
                break;
            }
            case 23: {
                HeapEGraph tempND = new HeapEGraph(this, null, this._space.graph());
                toSet = tempND;
                toGet = new NDTree(tempND);
            }
        }
        this.internal_set(p_key, p_type, toSet, true, false);
        return toGet;
    }

    @Override
    public final Object getOrCreate(String key, byte elemType) {
        return this.getOrCreateAt(this._space.graph().resolver().stringToHash(key, true), elemType);
    }

    @Override
    public final void declareDirty() {
        if (this._space != null && !this._dirty) {
            this._dirty = true;
            this._space.notifyUpdate(this._index);
        }
    }

    @Override
    public final synchronized void save(final Buffer buffer) {
        Base64.encodeIntToBuffer(this._size, buffer);
        block17: for (int i = 0; i < this._size; ++i) {
            Object loopValue = this._v[i];
            if (loopValue == null) continue;
            buffer.write((byte)124);
            Base64.encodeIntToBuffer(this._type[i], buffer);
            buffer.write((byte)124);
            Base64.encodeIntToBuffer(this._k[i], buffer);
            buffer.write((byte)124);
            switch (this._type[i]) {
                case 2: {
                    Base64.encodeStringToBuffer((String)loopValue, buffer);
                    continue block17;
                }
                case 1: {
                    if (((Boolean)this._v[i]).booleanValue()) {
                        Base64.encodeIntToBuffer(CoreConstants.BOOL_TRUE, buffer);
                        continue block17;
                    }
                    Base64.encodeIntToBuffer(CoreConstants.BOOL_FALSE, buffer);
                    continue block17;
                }
                case 3: {
                    Base64.encodeLongToBuffer((Long)loopValue, buffer);
                    continue block17;
                }
                case 5: {
                    Base64.encodeDoubleToBuffer((Double)loopValue, buffer);
                    continue block17;
                }
                case 4: {
                    Base64.encodeIntToBuffer((Integer)loopValue, buffer);
                    continue block17;
                }
                case 6: {
                    double[] castedDoubleArr = (double[])loopValue;
                    Base64.encodeIntToBuffer(castedDoubleArr.length, buffer);
                    for (int j = 0; j < castedDoubleArr.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeDoubleToBuffer(castedDoubleArr[j], buffer);
                    }
                    continue block17;
                }
                case 7: {
                    long[] castedLongArr = (long[])loopValue;
                    Base64.encodeIntToBuffer(castedLongArr.length, buffer);
                    for (int j = 0; j < castedLongArr.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeLongToBuffer(castedLongArr[j], buffer);
                    }
                    continue block17;
                }
                case 8: {
                    int[] castedIntArr = (int[])loopValue;
                    Base64.encodeIntToBuffer(castedIntArr.length, buffer);
                    for (int j = 0; j < castedIntArr.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeIntToBuffer(castedIntArr[j], buffer);
                    }
                    continue block17;
                }
                case 13: {
                    HeapRelation castedLongArrRel = (HeapRelation)loopValue;
                    Base64.encodeIntToBuffer(castedLongArrRel.size(), buffer);
                    for (int j = 0; j < castedLongArrRel.size(); ++j) {
                        buffer.write((byte)58);
                        Base64.encodeLongToBuffer(castedLongArrRel.unsafe_get(j), buffer);
                    }
                    continue block17;
                }
                case 15: {
                    HeapDMatrix castedMatrix = (HeapDMatrix)loopValue;
                    double[] unsafeContent = castedMatrix.unsafe_data();
                    if (unsafeContent == null) continue block17;
                    Base64.encodeIntToBuffer(unsafeContent.length, buffer);
                    for (int j = 0; j < unsafeContent.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeDoubleToBuffer(unsafeContent[j], buffer);
                    }
                    continue block17;
                }
                case 16: {
                    HeapLMatrix castedLMatrix = (HeapLMatrix)loopValue;
                    long[] unsafeLContent = castedLMatrix.unsafe_data();
                    if (unsafeLContent == null) continue block17;
                    Base64.encodeIntToBuffer(unsafeLContent.length, buffer);
                    for (int j = 0; j < unsafeLContent.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeLongToBuffer(unsafeLContent[j], buffer);
                    }
                    continue block17;
                }
                case 12: {
                    HeapStringIntMap castedStringLongMap = (HeapStringIntMap)loopValue;
                    Base64.encodeIntToBuffer(castedStringLongMap.size(), buffer);
                    castedStringLongMap.unsafe_each(new StringLongMapCallBack(){

                        @Override
                        public void on(String key, long value) {
                            buffer.write((byte)58);
                            Base64.encodeStringToBuffer(key, buffer);
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(value, buffer);
                        }
                    });
                    continue block17;
                }
                case 10: {
                    HeapLongLongMap castedLongLongMap = (HeapLongLongMap)loopValue;
                    Base64.encodeIntToBuffer(castedLongLongMap.size(), buffer);
                    castedLongLongMap.unsafe_each(new LongLongMapCallBack(){

                        @Override
                        public void on(long key, long value) {
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(key, buffer);
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(value, buffer);
                        }
                    });
                    continue block17;
                }
                case 11: 
                case 14: {
                    HeapLongLongArrayMap castedLongLongArrayMap = (HeapLongLongArrayMap)loopValue;
                    Base64.encodeIntToBuffer(castedLongLongArrayMap.size(), buffer);
                    castedLongLongArrayMap.unsafe_each(new LongLongArrayMapCallBack(){

                        @Override
                        public void on(long key, long value) {
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(key, buffer);
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(value, buffer);
                        }
                    });
                    continue block17;
                }
                case 17: 
                case 22: 
                case 23: {
                    HeapEGraph castedEGraph = (HeapEGraph)loopValue;
                    HeapENode[] eNodes = castedEGraph._nodes;
                    int eGSize = castedEGraph.size();
                    Base64.encodeIntToBuffer(eGSize, buffer);
                    for (int j = 0; j < eGSize; ++j) {
                        buffer.write((byte)36);
                        eNodes[j].save(buffer);
                    }
                    castedEGraph._dirty = false;
                    continue block17;
                }
            }
        }
        this._dirty = false;
    }

    @Override
    public void saveDiff(Buffer buffer) {
    }

    @Override
    public final synchronized void each(NodeStateCallback callBack) {
        for (int i = 0; i < this._size; ++i) {
            if (this._v[i] == null) continue;
            callBack.on(this._k[i], this._type[i], this._v[i]);
        }
    }

    @Override
    public synchronized void loadFrom(StateChunk origin) {
        if (origin == null) {
            return;
        }
        HeapStateChunk casted = (HeapStateChunk)origin;
        this._capacity = casted._capacity;
        this._size = casted._size;
        if (casted._k != null) {
            int[] cloned_k = new int[this._capacity];
            System.arraycopy(casted._k, 0, cloned_k, 0, this._capacity);
            this._k = cloned_k;
        }
        if (casted._type != null) {
            byte[] cloned_type = new byte[this._capacity];
            System.arraycopy(casted._type, 0, cloned_type, 0, this._capacity);
            this._type = cloned_type;
        }
        if (casted.next_and_hash != null) {
            int[] cloned_hash = new int[this._capacity * 3];
            System.arraycopy(casted.next_and_hash, 0, cloned_hash, 0, this._capacity * 3);
            this.next_and_hash = cloned_hash;
        }
        if (casted._v != null) {
            this._v = new Object[this._capacity];
            block10: for (int i = 0; i < this._size; ++i) {
                switch (casted._type[i]) {
                    case 10: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = ((HeapLongLongMap)casted._v[i]).cloneFor(this);
                        continue block10;
                    }
                    case 14: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = ((HeapRelationIndexed)casted._v[i]).cloneIRelFor(this, casted.graph());
                        continue block10;
                    }
                    case 11: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = ((HeapLongLongArrayMap)casted._v[i]).cloneFor(this);
                        continue block10;
                    }
                    case 12: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = ((HeapStringIntMap)casted._v[i]).cloneFor(this);
                        continue block10;
                    }
                    case 13: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = new HeapRelation(this, (HeapRelation)casted._v[i]);
                        continue block10;
                    }
                    case 15: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = new HeapDMatrix(this, (HeapDMatrix)casted._v[i]);
                        continue block10;
                    }
                    case 16: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = new HeapLMatrix(this, (HeapLMatrix)casted._v[i]);
                        continue block10;
                    }
                    case 17: {
                        if (casted._v[i] == null) continue block10;
                        this._v[i] = new HeapEGraph(this, (HeapEGraph)casted._v[i], this._space.graph());
                        continue block10;
                    }
                    default: {
                        this._v[i] = casted._v[i];
                    }
                }
            }
        }
    }

    private void internal_set(int p_key, byte p_type, Object p_unsafe_elem, boolean replaceIfPresent, boolean initial) {
        Object param_elem = null;
        if (p_unsafe_elem != null) {
            try {
                switch (p_type) {
                    case 1: {
                        param_elem = (boolean)((Boolean)p_unsafe_elem);
                        break;
                    }
                    case 4: {
                        if (p_unsafe_elem instanceof Integer) {
                            param_elem = (int)((Integer)p_unsafe_elem);
                            break;
                        }
                        if (p_unsafe_elem instanceof Double) {
                            double preCasting = (Double)p_unsafe_elem;
                            param_elem = (int)preCasting;
                            break;
                        }
                        if (p_unsafe_elem instanceof Long) {
                            long preCastingLong = (Long)p_unsafe_elem;
                            param_elem = (int)preCastingLong;
                            break;
                        }
                        if (p_unsafe_elem instanceof Float) {
                            float preCastingLong = ((Float)p_unsafe_elem).floatValue();
                            param_elem = (int)preCastingLong;
                            break;
                        }
                        if (p_unsafe_elem instanceof Byte) {
                            byte preCastingLong = (Byte)p_unsafe_elem;
                            param_elem = (int)preCastingLong;
                            break;
                        }
                        param_elem = (int)((Integer)p_unsafe_elem);
                        break;
                    }
                    case 5: {
                        if (p_unsafe_elem instanceof Double) {
                            param_elem = (double)((Double)p_unsafe_elem);
                            break;
                        }
                        if (p_unsafe_elem instanceof Integer) {
                            int preCasting = (Integer)p_unsafe_elem;
                            param_elem = (double)preCasting;
                            break;
                        }
                        if (p_unsafe_elem instanceof Long) {
                            long preCastingLong = (Long)p_unsafe_elem;
                            param_elem = (double)preCastingLong;
                            break;
                        }
                        if (p_unsafe_elem instanceof Float) {
                            float preCastingLong = ((Float)p_unsafe_elem).floatValue();
                            param_elem = (double)preCastingLong;
                            break;
                        }
                        if (p_unsafe_elem instanceof Byte) {
                            byte preCastingLong = (Byte)p_unsafe_elem;
                            param_elem = (double)preCastingLong;
                            break;
                        }
                        param_elem = (double)((Double)p_unsafe_elem);
                        break;
                    }
                    case 3: {
                        if (p_unsafe_elem instanceof Long) {
                            param_elem = (long)((Long)p_unsafe_elem);
                            break;
                        }
                        if (p_unsafe_elem instanceof Integer) {
                            int preCasting = (Integer)p_unsafe_elem;
                            param_elem = (long)preCasting;
                            break;
                        }
                        if (p_unsafe_elem instanceof Double) {
                            double preCastingLong = (Double)p_unsafe_elem;
                            param_elem = (long)preCastingLong;
                            break;
                        }
                        if (p_unsafe_elem instanceof Float) {
                            float preCastingLong = ((Float)p_unsafe_elem).floatValue();
                            param_elem = (long)preCastingLong;
                            break;
                        }
                        if (p_unsafe_elem instanceof Byte) {
                            byte preCastingLong = (Byte)p_unsafe_elem;
                            param_elem = (long)preCastingLong;
                            break;
                        }
                        param_elem = (long)((Long)p_unsafe_elem);
                        break;
                    }
                    case 2: {
                        param_elem = (String)p_unsafe_elem;
                        break;
                    }
                    case 15: {
                        param_elem = (DMatrix)p_unsafe_elem;
                        break;
                    }
                    case 16: {
                        param_elem = (LMatrix)p_unsafe_elem;
                        break;
                    }
                    case 13: {
                        param_elem = (Relation)p_unsafe_elem;
                        break;
                    }
                    case 6: {
                        double[] castedParamDouble = (double[])p_unsafe_elem;
                        double[] clonedDoubleArray = new double[castedParamDouble.length];
                        System.arraycopy(castedParamDouble, 0, clonedDoubleArray, 0, castedParamDouble.length);
                        param_elem = clonedDoubleArray;
                        break;
                    }
                    case 7: {
                        long[] castedParamLong = (long[])p_unsafe_elem;
                        long[] clonedLongArray = new long[castedParamLong.length];
                        System.arraycopy(castedParamLong, 0, clonedLongArray, 0, castedParamLong.length);
                        param_elem = clonedLongArray;
                        break;
                    }
                    case 8: {
                        int[] castedParamInt = (int[])p_unsafe_elem;
                        int[] clonedIntArray = new int[castedParamInt.length];
                        System.arraycopy(castedParamInt, 0, clonedIntArray, 0, castedParamInt.length);
                        param_elem = clonedIntArray;
                        break;
                    }
                    case 12: {
                        param_elem = (StringIntMap)p_unsafe_elem;
                        break;
                    }
                    case 10: {
                        param_elem = (LongLongMap)p_unsafe_elem;
                        break;
                    }
                    case 11: {
                        param_elem = (LongLongArrayMap)p_unsafe_elem;
                        break;
                    }
                    case 14: {
                        param_elem = (RelationIndexed)p_unsafe_elem;
                        break;
                    }
                    case 17: 
                    case 22: 
                    case 23: {
                        param_elem = (EGraph)p_unsafe_elem;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal Exception, unknown type");
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("GreyCat usage error, set method called with type " + Type.typeName(p_type) + " while param object is " + p_unsafe_elem);
            }
        }
        if (this._k == null) {
            if (param_elem == null) {
                return;
            }
            this._capacity = 8;
            this._k = new int[this._capacity];
            this._v = new Object[this._capacity];
            this._type = new byte[this._capacity];
            this._k[0] = p_key;
            this._v[0] = param_elem;
            this._type[0] = p_type;
            this._size = 1;
            if (!initial) {
                this.declareDirty();
            }
            return;
        }
        int entry = -1;
        int p_entry = -1;
        int hashIndex = -1;
        if (this.next_and_hash == null) {
            for (int i = 0; i < this._size; ++i) {
                if (this._k[i] != p_key) continue;
                entry = i;
                break;
            }
        } else {
            hashIndex = p_key % (this._capacity * 2);
            if (hashIndex < 0) {
                hashIndex *= -1;
            }
            int m = this.next_and_hash[this._capacity + hashIndex];
            while (m != -1) {
                if (this._k[m] == p_key) {
                    entry = m;
                    break;
                }
                p_entry = m;
                m = this.next_and_hash[m];
            }
        }
        if (entry != -1) {
            if (replaceIfPresent || p_type != this._type[entry]) {
                if (param_elem == null) {
                    int indexVictim;
                    if (this.next_and_hash != null) {
                        if (p_entry != -1) {
                            this.next_and_hash[p_entry] = this.next_and_hash[entry];
                        } else {
                            this.next_and_hash[this._capacity + hashIndex] = -1;
                        }
                    }
                    if (entry == (indexVictim = this._size - 1)) {
                        this._k[entry] = -1;
                        this._v[entry] = null;
                        this._type[entry] = -1;
                    } else {
                        this._k[entry] = this._k[indexVictim];
                        this._v[entry] = this._v[indexVictim];
                        this._type[entry] = this._type[indexVictim];
                        if (this.next_and_hash != null) {
                            int m;
                            this.next_and_hash[entry] = this.next_and_hash[indexVictim];
                            int victimHash = this._k[entry] % (this._capacity * 2);
                            if (victimHash < 0) {
                                victimHash *= -1;
                            }
                            if ((m = this.next_and_hash[this._capacity + victimHash]) == indexVictim) {
                                this.next_and_hash[this._capacity + victimHash] = entry;
                            } else {
                                while (m != -1) {
                                    if (this.next_and_hash[m] == indexVictim) {
                                        this.next_and_hash[m] = entry;
                                        break;
                                    }
                                    m = this.next_and_hash[m];
                                }
                            }
                        }
                        this._k[indexVictim] = -1;
                        this._v[indexVictim] = null;
                        this._type[indexVictim] = -1;
                    }
                    --this._size;
                } else {
                    this._v[entry] = param_elem;
                    if (this._type[entry] != p_type) {
                        this._type[entry] = p_type;
                    }
                }
            }
            if (!initial) {
                this.declareDirty();
            }
            return;
        }
        if (this._size < this._capacity) {
            this._k[this._size] = p_key;
            this._v[this._size] = param_elem;
            this._type[this._size] = p_type;
            if (this.next_and_hash != null) {
                this.next_and_hash[this._size] = this.next_and_hash[this._capacity + hashIndex];
                this.next_and_hash[this._capacity + hashIndex] = this._size;
            }
            ++this._size;
            if (!initial) {
                this.declareDirty();
            }
            return;
        }
        int newCapacity = this._capacity * 2;
        int[] ex_k = new int[newCapacity];
        System.arraycopy(this._k, 0, ex_k, 0, this._capacity);
        this._k = ex_k;
        Object[] ex_v = new Object[newCapacity];
        System.arraycopy(this._v, 0, ex_v, 0, this._capacity);
        this._v = ex_v;
        byte[] ex_type = new byte[newCapacity];
        System.arraycopy(this._type, 0, ex_type, 0, this._capacity);
        this._type = ex_type;
        this._capacity = newCapacity;
        this._k[this._size] = p_key;
        this._v[this._size] = param_elem;
        this._type[this._size] = p_type;
        ++this._size;
        this.next_and_hash = new int[this._capacity * 3];
        Arrays.fill(this.next_and_hash, 0, this._capacity * 3, -1);
        int double_capacity = this._capacity * 2;
        int i = 0;
        while (i < this._size) {
            int keyHash = this._k[i] % double_capacity;
            if (keyHash < 0) {
                keyHash *= -1;
            }
            this.next_and_hash[i] = this.next_and_hash[this._capacity + keyHash];
            this.next_and_hash[this._capacity + keyHash] = i++;
        }
        if (!initial) {
            this.declareDirty();
        }
    }

    private void allocate(int newCapacity) {
        if (newCapacity <= this._capacity) {
            return;
        }
        int[] ex_k = new int[newCapacity];
        if (this._k != null) {
            System.arraycopy(this._k, 0, ex_k, 0, this._capacity);
        }
        this._k = ex_k;
        Object[] ex_v = new Object[newCapacity];
        if (this._v != null) {
            System.arraycopy(this._v, 0, ex_v, 0, this._capacity);
        }
        this._v = ex_v;
        byte[] ex_type = new byte[newCapacity];
        if (this._type != null) {
            System.arraycopy(this._type, 0, ex_type, 0, this._capacity);
        }
        this._type = ex_type;
        this._capacity = newCapacity;
        this.next_and_hash = new int[this._capacity * 3];
        Arrays.fill(this.next_and_hash, 0, this._capacity * 3, -1);
        int i = 0;
        while (i < this._size) {
            int keyHash = this._k[i] % (this._capacity * 2);
            if (keyHash < 0) {
                keyHash *= -1;
            }
            this.next_and_hash[i] = this.next_and_hash[this._capacity + keyHash];
            this.next_and_hash[this._capacity + keyHash] = i++;
        }
    }

    @Override
    public final synchronized void load(Buffer buffer) {
        if (buffer != null && buffer.length() > 0L) {
            boolean initial = this._k == null;
            long payloadSize = buffer.length();
            long previous = 0L;
            long cursor = 0L;
            int state = 0;
            byte read_type = -1;
            int read_key = -1;
            while (cursor < payloadSize) {
                byte current = buffer.read(cursor);
                if (current == 124) {
                    block0 : switch (state) {
                        case 0: {
                            this.allocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                            state = 1;
                            previous = ++cursor;
                            break;
                        }
                        case 1: {
                            read_type = (byte)Base64.decodeToIntWithBounds(buffer, previous, cursor);
                            state = 2;
                            previous = ++cursor;
                            break;
                        }
                        case 2: {
                            read_key = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                            switch (read_type) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: {
                                    state = 3;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 6: {
                                    double[] doubleArrayLoaded = null;
                                    int doubleArrayIndex = 0;
                                    previous = ++cursor;
                                    current = buffer.read(cursor);
                                    while (cursor < payloadSize && current != 124) {
                                        if (current == 58) {
                                            if (doubleArrayLoaded == null) {
                                                doubleArrayLoaded = new double[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                            } else {
                                                doubleArrayLoaded[doubleArrayIndex] = Base64.decodeToDoubleWithBounds(buffer, previous, cursor);
                                                ++doubleArrayIndex;
                                            }
                                            previous = cursor + 1L;
                                        }
                                        if (++cursor >= payloadSize) continue;
                                        current = buffer.read(cursor);
                                    }
                                    if (doubleArrayLoaded == null) {
                                        doubleArrayLoaded = new double[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                    } else {
                                        doubleArrayLoaded[doubleArrayIndex] = Base64.decodeToDoubleWithBounds(buffer, previous, cursor);
                                    }
                                    this.internal_set(read_key, read_type, doubleArrayLoaded, true, initial);
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 7: {
                                    long[] longArrayLoaded = null;
                                    int longArrayIndex = 0;
                                    previous = ++cursor;
                                    current = buffer.read(cursor);
                                    while (cursor < payloadSize && current != 124) {
                                        if (current == 58) {
                                            if (longArrayLoaded == null) {
                                                longArrayLoaded = new long[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                            } else {
                                                longArrayLoaded[longArrayIndex] = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                                                ++longArrayIndex;
                                            }
                                            previous = cursor + 1L;
                                        }
                                        if (++cursor >= payloadSize) continue;
                                        current = buffer.read(cursor);
                                    }
                                    if (longArrayLoaded == null) {
                                        longArrayLoaded = new long[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                    } else {
                                        longArrayLoaded[longArrayIndex] = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                                    }
                                    this.internal_set(read_key, read_type, longArrayLoaded, true, initial);
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 8: {
                                    int[] intArrayLoaded = null;
                                    int intArrayIndex = 0;
                                    previous = ++cursor;
                                    current = buffer.read(cursor);
                                    while (cursor < payloadSize && current != 124) {
                                        if (current == 58) {
                                            if (intArrayLoaded == null) {
                                                intArrayLoaded = new int[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                            } else {
                                                intArrayLoaded[intArrayIndex] = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                                                ++intArrayIndex;
                                            }
                                            previous = cursor + 1L;
                                        }
                                        if (++cursor >= payloadSize) continue;
                                        current = buffer.read(cursor);
                                    }
                                    if (intArrayLoaded == null) {
                                        intArrayLoaded = new int[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                    } else {
                                        intArrayLoaded[intArrayIndex] = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                                    }
                                    this.internal_set(read_key, read_type, intArrayLoaded, true, initial);
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 13: {
                                    HeapRelation relation = new HeapRelation(this, null);
                                    ++cursor;
                                    cursor = relation.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, relation, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 15: {
                                    HeapDMatrix matrix = new HeapDMatrix(this, null);
                                    ++cursor;
                                    cursor = matrix.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, matrix, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 16: {
                                    HeapLMatrix lmatrix = new HeapLMatrix(this, null);
                                    ++cursor;
                                    cursor = lmatrix.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, lmatrix, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 10: {
                                    HeapLongLongMap l2lmap = new HeapLongLongMap(this);
                                    ++cursor;
                                    cursor = l2lmap.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, l2lmap, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 11: {
                                    HeapLongLongArrayMap l2lrmap = new HeapLongLongArrayMap(this);
                                    ++cursor;
                                    cursor = l2lrmap.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, l2lrmap, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 14: {
                                    HeapRelationIndexed relationIndexed = new HeapRelationIndexed(this, this._space.graph());
                                    ++cursor;
                                    cursor = relationIndexed.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, relationIndexed, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 12: {
                                    HeapStringIntMap s2lmap = new HeapStringIntMap(this);
                                    ++cursor;
                                    cursor = s2lmap.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, s2lmap, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                                case 17: 
                                case 22: 
                                case 23: {
                                    HeapEGraph eGraph = new HeapEGraph(this, null, this.graph());
                                    ++cursor;
                                    cursor = eGraph.load(buffer, cursor, payloadSize);
                                    this.internal_set(read_key, read_type, eGraph, true, initial);
                                    if (cursor >= payloadSize || (current = buffer.read(cursor)) != 124 || cursor >= payloadSize) break block0;
                                    state = 1;
                                    previous = ++cursor;
                                    break block0;
                                }
                            }
                            throw new RuntimeException("Not implemented yet!!!");
                        }
                        case 3: {
                            this.load_primitive(read_key, read_type, buffer, previous, cursor, initial);
                            state = 1;
                            previous = ++cursor;
                        }
                    }
                    continue;
                }
                ++cursor;
            }
            if (state == 3) {
                this.load_primitive(read_key, read_type, buffer, previous, cursor, initial);
            }
        }
    }

    private void load_primitive(int read_key, byte read_type, Buffer buffer, long previous, long cursor, boolean initial) {
        switch (read_type) {
            case 1: {
                this.internal_set(read_key, read_type, (byte)Base64.decodeToIntWithBounds(buffer, previous, cursor) == CoreConstants.BOOL_TRUE, true, initial);
                break;
            }
            case 4: {
                this.internal_set(read_key, read_type, Base64.decodeToIntWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 5: {
                this.internal_set(read_key, read_type, Base64.decodeToDoubleWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 3: {
                this.internal_set(read_key, read_type, Base64.decodeToLongWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 2: {
                this.internal_set(read_key, read_type, Base64.decodeToStringWithBounds(buffer, previous, cursor), true, initial);
            }
        }
    }

    @Override
    public final void loadDiff(Buffer buffer) {
        this.load(buffer);
    }
}

