/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.internal.heap.HeapContainer;
import greycat.struct.Buffer;
import greycat.struct.StringIntMap;
import greycat.struct.StringLongMapCallBack;
import greycat.utility.Base64;
import greycat.utility.HashHelper;
import java.util.Arrays;

class HeapStringIntMap
implements StringIntMap {
    private final HeapContainer parent;
    private int mapSize = 0;
    private int capacity = 0;
    private String[] keys = null;
    private int[] keysH = null;
    private int[] values = null;
    private int[] nexts = null;
    private int[] hashs = null;

    HeapStringIntMap(HeapContainer p_parent) {
        this.parent = p_parent;
    }

    private String key(int i) {
        return this.keys[i];
    }

    private void setKey(int i, String newValue) {
        this.keys[i] = newValue;
    }

    private int keyH(int i) {
        return this.keysH[i];
    }

    private void setKeyH(int i, int newValue) {
        this.keysH[i] = newValue;
    }

    private int value(int i) {
        return this.values[i];
    }

    private void setValue(int i, int newValue) {
        this.values[i] = newValue;
    }

    private int next(int i) {
        return this.nexts[i];
    }

    private void setNext(int i, int newValue) {
        this.nexts[i] = newValue;
    }

    private int hash(int i) {
        return this.hashs[i];
    }

    private void setHash(int i, int newValue) {
        this.hashs[i] = newValue;
    }

    void reallocate(int newCapacity) {
        if (newCapacity > this.capacity) {
            String[] new_keys = new String[newCapacity];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, new_keys, 0, this.capacity);
            }
            this.keys = new_keys;
            int[] new_keysH = new int[newCapacity];
            if (this.keysH != null) {
                System.arraycopy(this.keysH, 0, new_keysH, 0, this.capacity);
            }
            this.keysH = new_keysH;
            int[] new_values = new int[newCapacity];
            if (this.values != null) {
                System.arraycopy(this.values, 0, new_values, 0, this.capacity);
            }
            this.values = new_values;
            int[] new_nexts = new int[newCapacity];
            int[] new_hashes = new int[newCapacity * 2];
            Arrays.fill(new_nexts, 0, newCapacity, -1);
            Arrays.fill(new_hashes, 0, newCapacity * 2, -1);
            this.hashs = new_hashes;
            this.nexts = new_nexts;
            int double_capacity = this.capacity * 2;
            for (int i = 0; i < this.mapSize; ++i) {
                int new_key_hash = this.keyH(i) % double_capacity;
                if (new_key_hash < 0) {
                    new_key_hash *= -1;
                }
                this.setNext(i, this.hash(new_key_hash));
                this.setHash(new_key_hash, i);
            }
            this.capacity = newCapacity;
        }
    }

    HeapStringIntMap cloneFor(HeapContainer newContainer) {
        HeapStringIntMap cloned = new HeapStringIntMap(newContainer);
        cloned.mapSize = this.mapSize;
        cloned.capacity = this.capacity;
        if (this.keys != null) {
            String[] cloned_keys = new String[this.capacity];
            System.arraycopy(this.keys, 0, cloned_keys, 0, this.capacity);
            cloned.keys = cloned_keys;
        }
        if (this.keysH != null) {
            int[] cloned_keysH = new int[this.capacity];
            System.arraycopy(this.keysH, 0, cloned_keysH, 0, this.capacity);
            cloned.keysH = cloned_keysH;
        }
        if (this.values != null) {
            int[] cloned_values = new int[this.capacity];
            System.arraycopy(this.values, 0, cloned_values, 0, this.capacity);
            cloned.values = cloned_values;
        }
        if (this.nexts != null) {
            int[] cloned_nexts = new int[this.capacity];
            System.arraycopy(this.nexts, 0, cloned_nexts, 0, this.capacity);
            cloned.nexts = cloned_nexts;
        }
        if (this.hashs != null) {
            int[] cloned_hashs = new int[this.capacity * 2];
            System.arraycopy(this.hashs, 0, cloned_hashs, 0, this.capacity * 2);
            cloned.hashs = cloned_hashs;
        }
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getValue(String requestString) {
        int result = -1;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null) {
                int keyHash = HashHelper.hash(requestString);
                int hashIndex = keyHash % (this.capacity * 2);
                if (hashIndex < 0) {
                    hashIndex *= -1;
                }
                int m = this.hash(hashIndex);
                while (m >= 0) {
                    if (keyHash == this.keyH(m)) {
                        result = this.value(m);
                        break;
                    }
                    m = this.next(m);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getByHash(int keyHash) {
        String result = null;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null) {
                int hashIndex = keyHash % (this.capacity * 2);
                if (hashIndex < 0) {
                    hashIndex *= -1;
                }
                int m = this.hash(hashIndex);
                while (m >= 0) {
                    if (keyHash == this.keyH(m)) {
                        result = this.key(m);
                        break;
                    }
                    m = this.next(m);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsHash(int keyHash) {
        boolean result = false;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null) {
                int hashIndex = keyHash % (this.capacity * 2);
                if (hashIndex < 0) {
                    hashIndex *= -1;
                }
                int m = this.hash(hashIndex);
                while (m >= 0) {
                    if (keyHash == this.keyH(m)) {
                        result = true;
                        break;
                    }
                    m = this.next(m);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void each(StringLongMapCallBack callback) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.unsafe_each(callback);
        }
    }

    final void unsafe_each(StringLongMapCallBack callback) {
        for (int i = 0; i < this.mapSize; ++i) {
            callback.on(this.key(i), this.value(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        int result;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            result = this.mapSize;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(String requestKey) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null && this.mapSize != 0) {
                int hashCapacity;
                int keyHash = HashHelper.hash(requestKey);
                int hashIndex = keyHash % (hashCapacity = this.capacity * 2);
                if (hashIndex < 0) {
                    hashIndex *= -1;
                }
                int m = this.hash(hashIndex);
                int found = -1;
                while (m >= 0) {
                    if (keyHash == this.keyH(m)) {
                        found = m;
                        break;
                    }
                    m = this.next(m);
                }
                if (found != -1) {
                    int toRemoveHash = keyHash % hashCapacity;
                    if (toRemoveHash < 0) {
                        toRemoveHash *= -1;
                    }
                    if ((m = this.hash(toRemoveHash)) == found) {
                        this.setHash(toRemoveHash, this.next(m));
                    } else {
                        while (m != -1) {
                            int next_of_m = this.next(m);
                            if (next_of_m == found) {
                                this.setNext(m, this.next(next_of_m));
                                break;
                            }
                            m = next_of_m;
                        }
                    }
                    int lastIndex = this.mapSize - 1;
                    if (lastIndex == found) {
                        --this.mapSize;
                    } else {
                        String lastKey = this.key(lastIndex);
                        int lastKeyH = this.keyH(lastIndex);
                        this.setKey(found, lastKey);
                        this.setKeyH(found, lastKeyH);
                        this.setValue(found, this.value(lastIndex));
                        this.setNext(found, this.next(lastIndex));
                        int victimHash = lastKeyH % hashCapacity;
                        if (victimHash < 0) {
                            victimHash *= -1;
                        }
                        if ((m = this.hash(victimHash)) == lastIndex) {
                            this.setHash(victimHash, found);
                        } else {
                            while (m != -1) {
                                int next_of_m = this.next(m);
                                if (next_of_m == lastIndex) {
                                    this.setNext(m, found);
                                    break;
                                }
                                m = next_of_m;
                            }
                        }
                        --this.mapSize;
                    }
                    this.parent.declareDirty();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String insertKey, int insertValue) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            int keyHash = HashHelper.hash(insertKey);
            if (this.keys == null) {
                this.reallocate(8);
                this.setKey(0, insertKey);
                this.setKeyH(0, keyHash);
                this.setValue(0, insertValue);
                int hashIndex = keyHash % (this.capacity * 2);
                if (hashIndex < 0) {
                    hashIndex *= -1;
                }
                this.setHash(hashIndex, 0);
                this.setNext(0, -1);
                ++this.mapSize;
            } else {
                int currentHash;
                int hashCapacity = this.capacity * 2;
                int insertKeyHash = keyHash % hashCapacity;
                if (insertKeyHash < 0) {
                    insertKeyHash *= -1;
                }
                int m = currentHash = this.hash(insertKeyHash);
                int found = -1;
                while (m >= 0) {
                    if (keyHash == this.keyH(m)) {
                        if (!insertKey.equals(this.key(m))) {
                            throw new RuntimeException("Lotteries Winner !!! hashing conflict between " + this.key(m) + " and " + insertKey);
                        }
                        found = m;
                        break;
                    }
                    m = this.next(m);
                }
                if (found == -1) {
                    int lastIndex = this.mapSize;
                    if (lastIndex == this.capacity) {
                        this.reallocate(this.capacity * 2);
                    }
                    this.setKey(lastIndex, insertKey);
                    this.setKeyH(lastIndex, keyHash);
                    this.setValue(lastIndex, insertValue);
                    int hashIndex = keyHash % (this.capacity * 2);
                    if (hashIndex < 0) {
                        hashIndex *= -1;
                    }
                    this.setHash(hashIndex, lastIndex);
                    this.setNext(lastIndex, currentHash);
                    ++this.mapSize;
                    this.parent.declareDirty();
                } else if (this.value(found) != insertValue) {
                    this.setValue(found, insertValue);
                    this.parent.declareDirty();
                }
            }
        }
    }

    public final long load(Buffer buffer, long offset, long max) {
        long cursor = offset;
        byte current = buffer.read(cursor);
        boolean isFirst = true;
        long previous = offset;
        String previousKey = null;
        while (cursor < max && current != 124 && current != 36 && current != 37) {
            if (current == 58) {
                if (isFirst) {
                    this.reallocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                    isFirst = false;
                } else if (previousKey == null) {
                    previousKey = Base64.decodeToStringWithBounds(buffer, previous, cursor);
                } else {
                    this.put(previousKey, Base64.decodeToIntWithBounds(buffer, previous, cursor));
                    previousKey = null;
                }
                previous = cursor + 1L;
            }
            if (++cursor >= max) continue;
            current = buffer.read(cursor);
        }
        if (isFirst) {
            this.reallocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
        } else if (previousKey != null) {
            this.put(previousKey, Base64.decodeToIntWithBounds(buffer, previous, cursor));
        }
        return cursor;
    }
}

