/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.chunk.TimeTreeChunk;
import greycat.chunk.TreeWalker;
import greycat.internal.CoreConstants;
import greycat.internal.heap.HeapChunkSpace;
import greycat.struct.Buffer;
import greycat.utility.Base64;

class HeapTimeTreeChunk
implements TimeTreeChunk {
    private static final int META_SIZE = 3;
    private final long _index;
    private final HeapChunkSpace _space;
    private int _root = -1;
    private int[] _back_meta;
    private long[] _k;
    private boolean[] _colors;
    private boolean[] _diff;
    private volatile long _magic;
    private volatile int _size = 0;
    private boolean _dirty;
    private volatile long _extra;
    private volatile long _extra2;

    HeapTimeTreeChunk(HeapChunkSpace p_space, long p_index) {
        this._space = p_space;
        this._index = p_index;
        this._magic = 0L;
        this._dirty = false;
        this._extra = 0L;
        this._extra2 = 0L;
    }

    @Override
    public final long extra() {
        return this._extra;
    }

    @Override
    public final void setExtra(long extraValue) {
        this._extra = extraValue;
    }

    @Override
    public final long extra2() {
        return this._extra2;
    }

    @Override
    public final void setExtra2(long extraValue) {
        this._extra2 = extraValue;
    }

    @Override
    public final long world() {
        return this._space.worldByIndex(this._index);
    }

    @Override
    public final long time() {
        return this._space.timeByIndex(this._index);
    }

    @Override
    public final long id() {
        return this._space.idByIndex(this._index);
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final synchronized void range(long startKey, long endKey, long maxElements, TreeWalker walker) {
        int nbElements = 0;
        int indexEnd = this.internal_previousOrEqual_index(endKey);
        while (indexEnd != -1 && this.key(indexEnd) >= startKey && (long)nbElements < maxElements) {
            walker.elem(this.key(indexEnd));
            ++nbElements;
            indexEnd = this.internal_previous(indexEnd);
        }
    }

    @Override
    public final synchronized void save(Buffer buffer) {
        if (this._extra != 0x1FFFFFFFFFFFFFL && this._extra != 0L) {
            Base64.encodeLongToBuffer(this._extra, buffer);
            buffer.write((byte)124);
        }
        if (this._extra2 != 0x1FFFFFFFFFFFFFL && this._extra2 != 0L) {
            Base64.encodeLongToBuffer(this._extra2, buffer);
            buffer.write((byte)124);
        }
        Base64.encodeIntToBuffer(this._size, buffer);
        for (int i = 0; i < this._size; ++i) {
            buffer.write((byte)58);
            Base64.encodeLongToBuffer(this._k[i], buffer);
        }
        this._dirty = false;
        if (this._diff != null) {
            CoreConstants.fillBooleanArray(this._diff, false);
        }
    }

    @Override
    public final synchronized void saveDiff(Buffer buffer) {
        if (this._dirty) {
            if (this._extra != 0x1FFFFFFFFFFFFFL && this._extra != 0L) {
                Base64.encodeLongToBuffer(this._extra, buffer);
                buffer.write((byte)124);
            }
            if (this._extra2 != 0x1FFFFFFFFFFFFFL && this._extra2 != 0L) {
                Base64.encodeLongToBuffer(this._extra2, buffer);
                buffer.write((byte)124);
            }
            Base64.encodeIntToBuffer(this._size, buffer);
            for (int i = 0; i < this._size; ++i) {
                if (!this._diff[i]) continue;
                buffer.write((byte)58);
                Base64.encodeLongToBuffer(this._k[i], buffer);
            }
            this._dirty = false;
            CoreConstants.fillBooleanArray(this._diff, false);
        }
    }

    @Override
    public final synchronized void load(Buffer buffer) {
        this.internal_load(buffer, true);
    }

    @Override
    public synchronized void loadDiff(Buffer buffer) {
        if (this.internal_load(buffer, false) && !this._dirty) {
            this._dirty = true;
            if (this._space != null) {
                this._space.notifyUpdate(this._index);
            }
        }
    }

    private boolean internal_load(Buffer buffer, boolean initial) {
        long cursor;
        if (buffer == null || buffer.length() == 0L) {
            return false;
        }
        boolean isDirty = false;
        long previous = 0L;
        long payloadSize = buffer.length();
        boolean isFirst = true;
        boolean isFirstExtra = true;
        block4: for (cursor = 0L; cursor < payloadSize; ++cursor) {
            byte current = buffer.read(cursor);
            switch (current) {
                case 124: {
                    if (isFirstExtra) {
                        this._extra = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                        previous = cursor + 1L;
                        isFirstExtra = false;
                        continue block4;
                    }
                    this._extra2 = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                    previous = cursor + 1L;
                    continue block4;
                }
                case 58: {
                    if (isFirst) {
                        int treeSize = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                        int closePowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(treeSize) / Math.log(2.0)));
                        this.reallocate(closePowerOfTwo);
                        previous = cursor + 1L;
                        isFirst = false;
                        continue block4;
                    }
                    boolean insertResult = this.internal_insert(Base64.decodeToLongWithBounds(buffer, previous, cursor), initial);
                    isDirty = isDirty || insertResult;
                    previous = cursor + 1L;
                }
            }
        }
        boolean insertResult = this.internal_insert(Base64.decodeToLongWithBounds(buffer, previous, cursor), initial);
        isDirty = isDirty || insertResult;
        return isDirty;
    }

    @Override
    public final long index() {
        return this._index;
    }

    @Override
    public synchronized long previous(long key) {
        int result = this.internal_previous_index(key);
        long resultKey = result != -1 ? this.key(result) : 0x1FFFFFFFFFFFFFL;
        return resultKey;
    }

    @Override
    public synchronized long next(long key) {
        int result = this.internal_previousOrEqual_index(key);
        if (result != -1) {
            result = this.internal_next(result);
        }
        long resultKey = result != -1 ? this.key(result) : 0x1FFFFFFFFFFFFFL;
        return resultKey;
    }

    @Override
    public final synchronized long previousOrEqual(long key) {
        int result = this.internal_previousOrEqual_index(key);
        long resultKey = result != -1 ? this.key(result) : 0x1FFFFFFFFFFFFFL;
        return resultKey;
    }

    @Override
    public final long magic() {
        return this._magic;
    }

    @Override
    public final synchronized void insert(long p_key) {
        if (this.internal_insert(p_key, false)) {
            this.internal_set_dirty();
        }
    }

    @Override
    public final synchronized void unsafe_insert(long p_key) {
        this.internal_insert(p_key, false);
    }

    @Override
    public final byte chunkType() {
        return 1;
    }

    @Override
    public final synchronized void clearAt(long max) {
        long[] previousValue = this._k;
        this._k = new long[this._k.length];
        this._back_meta = new int[this._k.length * 3];
        this._colors = new boolean[this._k.length];
        this._diff = new boolean[this._k.length];
        CoreConstants.fillBooleanArray(this._diff, false);
        this._root = -1;
        int _previousSize = this._size;
        this._size = 0;
        for (int i = 0; i < _previousSize; ++i) {
            if (previousValue[i] == 0x1FFFFFFFFFFFFFL || previousValue[i] >= max) continue;
            this.internal_insert(previousValue[i], false);
        }
        this.internal_set_dirty();
    }

    private void reallocate(int newCapacity) {
        if (this._k != null && newCapacity <= this._k.length) {
            return;
        }
        long[] new_back_kv = new long[newCapacity];
        if (this._k != null) {
            System.arraycopy(this._k, 0, new_back_kv, 0, this._size);
        }
        boolean[] new_back_diff = new boolean[newCapacity];
        CoreConstants.fillBooleanArray(new_back_diff, false);
        if (this._diff != null) {
            System.arraycopy(this._diff, 0, new_back_diff, 0, this._size);
        }
        boolean[] new_back_colors = new boolean[newCapacity];
        if (this._colors != null) {
            System.arraycopy(this._colors, 0, new_back_colors, 0, this._size);
            for (int i = this._size; i < newCapacity; ++i) {
                new_back_colors[i] = false;
            }
        }
        int[] new_back_meta = new int[newCapacity * 3];
        if (this._back_meta != null) {
            System.arraycopy(this._back_meta, 0, new_back_meta, 0, this._size * 3);
            for (int i = this._size * 3; i < newCapacity * 3; ++i) {
                new_back_meta[i] = -1;
            }
        }
        this._back_meta = new_back_meta;
        this._k = new_back_kv;
        this._colors = new_back_colors;
        this._diff = new_back_diff;
    }

    private long key(int p_currentIndex) {
        if (p_currentIndex == -1) {
            return -1L;
        }
        return this._k[p_currentIndex];
    }

    private void setKey(int p_currentIndex, long p_paramIndex, boolean initial) {
        this._k[p_currentIndex] = p_paramIndex;
        if (!initial) {
            this._diff[p_currentIndex] = true;
        }
    }

    private int left(int p_currentIndex) {
        if (p_currentIndex == -1) {
            return -1;
        }
        return this._back_meta[p_currentIndex * 3];
    }

    private void setLeft(int p_currentIndex, int p_paramIndex) {
        this._back_meta[p_currentIndex * 3] = p_paramIndex;
    }

    private int right(int p_currentIndex) {
        if (p_currentIndex == -1) {
            return -1;
        }
        return this._back_meta[p_currentIndex * 3 + 1];
    }

    private void setRight(int p_currentIndex, int p_paramIndex) {
        this._back_meta[p_currentIndex * 3 + 1] = p_paramIndex;
    }

    private int parent(int p_currentIndex) {
        if (p_currentIndex == -1) {
            return -1;
        }
        return this._back_meta[p_currentIndex * 3 + 2];
    }

    private void setParent(int p_currentIndex, int p_paramIndex) {
        this._back_meta[p_currentIndex * 3 + 2] = p_paramIndex;
    }

    private boolean color(int p_currentIndex) {
        if (p_currentIndex == -1) {
            return true;
        }
        return this._colors[p_currentIndex];
    }

    private void setColor(int p_currentIndex, boolean p_paramIndex) {
        this._colors[p_currentIndex] = p_paramIndex;
    }

    private int grandParent(int p_currentIndex) {
        if (p_currentIndex == -1) {
            return -1;
        }
        if (this.parent(p_currentIndex) != -1) {
            return this.parent(this.parent(p_currentIndex));
        }
        return -1;
    }

    private int sibling(int p_currentIndex) {
        if (this.parent(p_currentIndex) == -1) {
            return -1;
        }
        if (p_currentIndex == this.left(this.parent(p_currentIndex))) {
            return this.right(this.parent(p_currentIndex));
        }
        return this.left(this.parent(p_currentIndex));
    }

    private int uncle(int p_currentIndex) {
        if (this.parent(p_currentIndex) != -1) {
            return this.sibling(this.parent(p_currentIndex));
        }
        return -1;
    }

    private int internal_previous(int p_index) {
        int p = p_index;
        if (this.left(p) != -1) {
            p = this.left(p);
            while (this.right(p) != -1) {
                p = this.right(p);
            }
            return p;
        }
        if (this.parent(p) != -1) {
            if (p == this.right(this.parent(p))) {
                return this.parent(p);
            }
            while (this.parent(p) != -1 && p == this.left(this.parent(p))) {
                p = this.parent(p);
            }
            return this.parent(p);
        }
        return -1;
    }

    private int internal_next(int p_index) {
        int p = p_index;
        if (this.right(p) != -1) {
            p = this.right(p);
            while (this.left(p) != -1) {
                p = this.left(p);
            }
            return p;
        }
        if (this.parent(p) != -1) {
            if (p == this.left(this.parent(p))) {
                return this.parent(p);
            }
            while (this.parent(p) != -1 && p == this.right(this.parent(p))) {
                p = this.parent(p);
            }
            return this.parent(p);
        }
        return -1;
    }

    private int internal_previousOrEqual_index(long p_key) {
        int p = this._root;
        if (p == -1) {
            return p;
        }
        while (p != -1) {
            if (p_key == this.key(p)) {
                return p;
            }
            if (p_key > this.key(p)) {
                if (this.right(p) != -1) {
                    p = this.right(p);
                    continue;
                }
                return p;
            }
            if (this.left(p) != -1) {
                p = this.left(p);
                continue;
            }
            int parent = this.parent(p);
            long ch = p;
            while (parent != -1 && ch == (long)this.left(parent)) {
                ch = parent;
                parent = this.parent(parent);
            }
            return parent;
        }
        return -1;
    }

    private int internal_previous_index(long p_key) {
        int p = this._root;
        if (p == -1) {
            return p;
        }
        while (p != -1) {
            if (p_key > this.key(p)) {
                if (this.right(p) != -1) {
                    p = this.right(p);
                    continue;
                }
                return p;
            }
            if (this.left(p) != -1) {
                p = this.left(p);
                continue;
            }
            int parent = this.parent(p);
            long ch = p;
            while (parent != -1 && ch == (long)this.left(parent)) {
                ch = parent;
                parent = this.parent(parent);
            }
            return parent;
        }
        return -1;
    }

    private void rotateLeft(int n) {
        int r = this.right(n);
        this.replaceNode(n, r);
        this.setRight(n, this.left(r));
        if (this.left(r) != -1) {
            this.setParent(this.left(r), n);
        }
        this.setLeft(r, n);
        this.setParent(n, r);
    }

    private void rotateRight(int n) {
        int l = this.left(n);
        this.replaceNode(n, l);
        this.setLeft(n, this.right(l));
        if (this.right(l) != -1) {
            this.setParent(this.right(l), n);
        }
        this.setRight(l, n);
        this.setParent(n, l);
    }

    private void replaceNode(int oldn, int newn) {
        if (this.parent(oldn) == -1) {
            this._root = newn;
        } else if (oldn == this.left(this.parent(oldn))) {
            this.setLeft(this.parent(oldn), newn);
        } else {
            this.setRight(this.parent(oldn), newn);
        }
        if (newn != -1) {
            this.setParent(newn, this.parent(oldn));
        }
    }

    private void insertCase1(int n) {
        if (this.parent(n) == -1) {
            this.setColor(n, true);
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(int n) {
        if (!this.color(this.parent(n))) {
            this.insertCase3(n);
        }
    }

    private void insertCase3(int n) {
        if (!this.color(this.uncle(n))) {
            this.setColor(this.parent(n), true);
            this.setColor(this.uncle(n), true);
            this.setColor(this.grandParent(n), false);
            this.insertCase1(this.grandParent(n));
        } else {
            this.insertCase4(n);
        }
    }

    private void insertCase4(int n_n) {
        int n = n_n;
        if (n == this.right(this.parent(n)) && this.parent(n) == this.left(this.grandParent(n))) {
            this.rotateLeft(this.parent(n));
            n = this.left(n);
        } else if (n == this.left(this.parent(n)) && this.parent(n) == this.right(this.grandParent(n))) {
            this.rotateRight(this.parent(n));
            n = this.right(n);
        }
        this.insertCase5(n);
    }

    private void insertCase5(int n) {
        this.setColor(this.parent(n), true);
        this.setColor(this.grandParent(n), false);
        if (n == this.left(this.parent(n)) && this.parent(n) == this.left(this.grandParent(n))) {
            this.rotateRight(this.grandParent(n));
        } else {
            this.rotateLeft(this.grandParent(n));
        }
    }

    private boolean internal_insert(long p_key, boolean initial) {
        int newIndex;
        if (this._k == null || this._k.length == this._size) {
            int length = this._size;
            length = length == 0 ? 8 : (length *= 2);
            this.reallocate(length);
        }
        if ((newIndex = this._size) == 0) {
            this.setKey(newIndex, p_key, initial);
            this.setColor(newIndex, false);
            this.setLeft(newIndex, -1);
            this.setRight(newIndex, -1);
            this.setParent(newIndex, -1);
            this._root = newIndex;
            this._size = 1;
        } else {
            int n = this._root;
            while (true) {
                if (p_key == this.key(n)) {
                    return false;
                }
                if (p_key < this.key(n)) {
                    if (this.left(n) == -1) {
                        this.setKey(newIndex, p_key, initial);
                        this.setColor(newIndex, false);
                        this.setLeft(newIndex, -1);
                        this.setRight(newIndex, -1);
                        this.setParent(newIndex, -1);
                        this.setLeft(n, newIndex);
                        ++this._size;
                        break;
                    }
                    n = this.left(n);
                    continue;
                }
                if (this.right(n) == -1) {
                    this.setKey(newIndex, p_key, initial);
                    this.setColor(newIndex, false);
                    this.setLeft(newIndex, -1);
                    this.setRight(newIndex, -1);
                    this.setParent(newIndex, -1);
                    this.setRight(n, newIndex);
                    ++this._size;
                    break;
                }
                n = this.right(n);
            }
            this.setParent(newIndex, n);
        }
        this.insertCase1(newIndex);
        return true;
    }

    private void internal_set_dirty() {
        ++this._magic;
        if (this._space != null && !this._dirty) {
            this._dirty = true;
            this._space.notifyUpdate(this._index);
        }
    }
}

