/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.chunk.WorldOrderChunk;
import greycat.internal.CoreConstants;
import greycat.internal.heap.HeapChunkSpace;
import greycat.struct.Buffer;
import greycat.struct.LongLongMapCallBack;
import greycat.utility.Base64;
import greycat.utility.HashHelper;
import java.util.Arrays;
import sun.misc.Unsafe;

final class HeapWorldOrderChunk
implements WorldOrderChunk {
    private static final Unsafe unsafe = greycat.utility.Unsafe.getUnsafe();
    private final HeapChunkSpace _space;
    private final long _index;
    private volatile int _lock;
    private volatile int _externalLock;
    private volatile long _magic;
    private volatile long _extra;
    private volatile int _size;
    private int _capacity;
    private long[] _kv;
    private boolean[] _diff;
    private int[] _next;
    private int[] _hash;
    private boolean _dirty;
    private static final long _lockOffset;
    private static final long _externalLockOffset;

    HeapWorldOrderChunk(HeapChunkSpace p_space, long p_index) {
        this._index = p_index;
        this._space = p_space;
        this._lock = 0;
        this._magic = 0L;
        this._extra = 0x1FFFFFFFFFFFFFL;
        this._size = 0;
        this._capacity = 0;
        this._kv = null;
        this._next = null;
        this._diff = null;
        this._hash = null;
        this._dirty = false;
    }

    @Override
    public final long world() {
        return this._space.worldByIndex(this._index);
    }

    @Override
    public final long time() {
        return this._space.timeByIndex(this._index);
    }

    @Override
    public final long id() {
        return this._space.idByIndex(this._index);
    }

    @Override
    public final long extra() {
        return this._extra;
    }

    @Override
    public final void setExtra(long extraValue) {
        this._extra = extraValue;
    }

    @Override
    public final void lock() {
        while (!unsafe.compareAndSwapInt(this, _lockOffset, 0, 1)) {
        }
    }

    @Override
    public final void unlock() {
        if (!unsafe.compareAndSwapInt(this, _lockOffset, 1, 0)) {
            throw new RuntimeException("CAS Error !!!");
        }
    }

    @Override
    public final void externalLock() {
        while (!unsafe.compareAndSwapInt(this, _externalLockOffset, 0, 1)) {
        }
    }

    @Override
    public final void externalUnlock() {
        if (!unsafe.compareAndSwapInt(this, _externalLockOffset, 1, 0)) {
            throw new RuntimeException("CAS Error !!!");
        }
    }

    @Override
    public final long magic() {
        return this._magic;
    }

    @Override
    public final synchronized void each(LongLongMapCallBack callback) {
        for (int i = 0; i < this._size; ++i) {
            callback.on(this._kv[i * 2], this._kv[i * 2 + 1]);
        }
    }

    @Override
    public final synchronized long get(long key) {
        if (this._size > 0) {
            int index = (int)HashHelper.longHash(key, this._capacity * 2);
            int m = this._hash[index];
            while (m >= 0) {
                if (key == this._kv[m * 2]) {
                    return this._kv[m * 2 + 1];
                }
                m = this._next[m];
            }
        }
        return 0x1FFFFFFFFFFFFFL;
    }

    @Override
    public final synchronized void put(long key, long value) {
        this.internal_put(key, value, true);
    }

    private void internal_put(long key, long value, boolean notifyUpdate) {
        if (this._capacity > 0) {
            int hashIndex = (int)HashHelper.longHash(key, this._capacity * 2);
            int m = this._hash[hashIndex];
            int found = -1;
            while (m >= 0) {
                if (key == this._kv[m * 2]) {
                    found = m;
                    break;
                }
                m = this._next[m];
            }
            if (found == -1) {
                if (this._capacity == this._size) {
                    this.resize(this._capacity * 2);
                    hashIndex = (int)HashHelper.longHash(key, this._capacity * 2);
                }
                this._kv[this._size * 2] = key;
                this._kv[this._size * 2 + 1] = value;
                if (notifyUpdate) {
                    this._diff[this._size] = true;
                }
                this._next[this._size] = this._hash[hashIndex];
                this._hash[hashIndex] = this._size++;
                ++this._magic;
                if (notifyUpdate && !this._dirty) {
                    this._dirty = true;
                    if (this._space != null) {
                        this._space.notifyUpdate(this._index);
                    }
                }
            } else if (this._kv[found * 2 + 1] != value) {
                this._kv[found * 2 + 1] = value;
                if (notifyUpdate) {
                    this._diff[found] = true;
                }
                ++this._magic;
                if (notifyUpdate && !this._dirty) {
                    this._dirty = true;
                    if (this._space != null) {
                        this._space.notifyUpdate(this._index);
                    }
                }
            }
        } else {
            this._capacity = 8;
            this._next = new int[this._capacity];
            Arrays.fill(this._next, 0, this._capacity, -1);
            this._diff = new boolean[this._capacity];
            CoreConstants.fillBooleanArray(this._diff, false);
            this._hash = new int[this._capacity * 2];
            Arrays.fill(this._hash, 0, this._capacity * 2, -1);
            this._kv = new long[this._capacity * 2];
            this._size = 1;
            this._kv[0] = key;
            this._kv[1] = value;
            if (notifyUpdate) {
                this._diff[0] = true;
            }
            this._hash[(int)HashHelper.longHash((long)key, (long)((long)(this._capacity * 2)))] = 0;
            if (notifyUpdate && !this._dirty) {
                this._dirty = true;
                if (this._space != null) {
                    this._space.notifyUpdate(this._index);
                }
            }
        }
    }

    private boolean resize(int newCapacity) {
        if (newCapacity > this._capacity) {
            if (this._kv == null) {
                this._kv = new long[newCapacity * 2];
                this._hash = new int[newCapacity * 2];
                this._next = new int[newCapacity];
                this._diff = new boolean[newCapacity];
                this._capacity = newCapacity;
                Arrays.fill(this._next, 0, newCapacity, -1);
                CoreConstants.fillBooleanArray(this._diff, false);
                Arrays.fill(this._hash, 0, newCapacity * 2, -1);
                return true;
            }
            long[] temp_kv = new long[newCapacity * 2];
            System.arraycopy(this._kv, 0, temp_kv, 0, this._size * 2);
            boolean[] temp_diff = new boolean[newCapacity];
            CoreConstants.fillBooleanArray(temp_diff, false);
            System.arraycopy(this._diff, 0, temp_diff, 0, this._size);
            int[] temp_next = new int[newCapacity];
            int[] temp_hash = new int[newCapacity * 2];
            Arrays.fill(temp_next, 0, newCapacity, -1);
            Arrays.fill(temp_hash, 0, newCapacity * 2, -1);
            int i = 0;
            while (i < this._size) {
                int loopIndex = (int)HashHelper.longHash(temp_kv[i * 2], newCapacity * 2);
                temp_next[i] = temp_hash[loopIndex];
                temp_hash[loopIndex] = i++;
            }
            this._capacity = newCapacity;
            this._hash = temp_hash;
            this._next = temp_next;
            this._kv = temp_kv;
            this._diff = temp_diff;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void load(Buffer buffer) {
        this.internal_load(true, buffer);
    }

    @Override
    public synchronized void loadDiff(Buffer buffer) {
        this.internal_load(false, buffer);
    }

    private void internal_load(boolean initial, Buffer buffer) {
        if (buffer != null && buffer.length() > 0L) {
            long cursor;
            long bufferSize = buffer.length();
            boolean initDone = false;
            long previousStart = 0L;
            long loopKey = 0x1FFFFFFFFFFFFFL;
            block4: for (cursor = 0L; cursor < bufferSize; ++cursor) {
                byte current = buffer.read(cursor);
                switch (current) {
                    case 124: {
                        this._extra = Base64.decodeToLongWithBounds(buffer, previousStart, cursor);
                        previousStart = cursor + 1L;
                        continue block4;
                    }
                    case 58: {
                        if (!initDone) {
                            this.resize(Base64.decodeToIntWithBounds(buffer, previousStart, cursor));
                            initDone = true;
                        } else if (loopKey == 0x1FFFFFFFFFFFFFL) {
                            loopKey = Base64.decodeToLongWithBounds(buffer, previousStart, cursor);
                        } else {
                            long loopValue = Base64.decodeToLongWithBounds(buffer, previousStart, cursor);
                            this.internal_put(loopKey, loopValue, !initial);
                            loopKey = 0x1FFFFFFFFFFFFFL;
                        }
                        previousStart = cursor + 1L;
                    }
                }
            }
            if (!initDone) {
                this.resize((int)Base64.decodeToLongWithBounds(buffer, 0L, cursor));
            } else if (loopKey != 0x1FFFFFFFFFFFFFL) {
                long loopValue = Base64.decodeToLongWithBounds(buffer, previousStart, cursor);
                this.internal_put(loopKey, loopValue, !initial);
            }
        }
    }

    @Override
    public final long index() {
        return this._index;
    }

    @Override
    public final synchronized void remove(long key) {
        throw new RuntimeException("Not implemented yet!!!");
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final byte chunkType() {
        return 2;
    }

    @Override
    public final synchronized void save(Buffer buffer) {
        if (this._extra != 0x1FFFFFFFFFFFFFL) {
            Base64.encodeLongToBuffer(this._extra, buffer);
            buffer.write((byte)124);
        }
        Base64.encodeIntToBuffer(this._size, buffer);
        for (int i = 0; i < this._size; ++i) {
            buffer.write((byte)58);
            Base64.encodeLongToBuffer(this._kv[i * 2], buffer);
            buffer.write((byte)58);
            Base64.encodeLongToBuffer(this._kv[i * 2 + 1], buffer);
        }
        this._dirty = false;
    }

    @Override
    public final synchronized void saveDiff(Buffer buffer) {
        if (this._dirty) {
            if (this._extra != 0x1FFFFFFFFFFFFFL) {
                Base64.encodeLongToBuffer(this._extra, buffer);
                buffer.write((byte)124);
            }
            Base64.encodeIntToBuffer(this._size, buffer);
            for (int i = 0; i < this._size; ++i) {
                if (!this._diff[i]) continue;
                buffer.write((byte)58);
                Base64.encodeLongToBuffer(this._kv[i * 2], buffer);
                buffer.write((byte)58);
                Base64.encodeLongToBuffer(this._kv[i * 2 + 1], buffer);
            }
            this._dirty = false;
        }
    }

    static {
        try {
            _lockOffset = unsafe.objectFieldOffset(HeapWorldOrderChunk.class.getDeclaredField("_lock"));
            _externalLockOffset = unsafe.objectFieldOffset(HeapWorldOrderChunk.class.getDeclaredField("_externalLock"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

