/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.CoreDeferCounter;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.plugin.Job;
import greycat.struct.Buffer;

class ActionAddRemoveToGlobalIndex
implements Action {
    private final String _name;
    private final String[] _attributes;
    private final boolean _timed;
    private final boolean _remove;

    ActionAddRemoveToGlobalIndex(boolean remove, boolean timed, String name, String ... attributes) {
        this._name = name;
        this._timed = timed;
        this._attributes = attributes;
        this._remove = remove;
    }

    @Override
    public final void eval(final TaskContext ctx) {
        TaskResult previousResult = ctx.result();
        String templatedIndexName = ctx.template(this._name);
        String[] templatedAttributes = ctx.templates(this._attributes);
        CoreDeferCounter counter = new CoreDeferCounter(previousResult.size());
        for (int i = 0; i < previousResult.size(); ++i) {
            Object loop = previousResult.get(i);
            if (loop instanceof BaseNode) {
                BaseNode loopBaseNode = (BaseNode)loop;
                long indexTime = -9007199254740990L;
                if (this._timed) {
                    indexTime = ctx.time();
                }
                ctx.graph().index(loopBaseNode.world(), indexTime, templatedIndexName, indexNode -> {
                    if (this._remove) {
                        indexNode.removeFromIndex(loopBaseNode, templatedAttributes);
                    } else {
                        indexNode.addToIndex(loopBaseNode, templatedAttributes);
                    }
                    counter.count();
                });
                continue;
            }
            counter.count();
        }
        counter.then(new Job(){

            @Override
            public void run() {
                ctx.continueTask();
            }
        });
    }

    @Override
    public final void serialize(Buffer builder) {
        if (this._timed) {
            builder.writeString(CoreActionNames.ADD_TO_GLOBAL_TIMED_INDEX);
        } else {
            builder.writeString(CoreActionNames.ADD_TO_GLOBAL_INDEX);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeStringParams(this._attributes, builder);
        builder.writeChar(')');
    }
}

