/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionAddRemoveVarToRelation
implements Action {
    private final String _name;
    private final String _varFrom;
    private final String[] _attributes;
    private final boolean _isAdd;

    ActionAddRemoveVarToRelation(boolean isAdd, String name, String varFrom, String ... attributes) {
        this._isAdd = isAdd;
        this._name = name;
        this._varFrom = varFrom;
        this._attributes = attributes;
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previousResult = ctx.result();
        TaskResult savedVar = ctx.variable(ctx.template(this._varFrom));
        String[] templatedAttributes = ctx.templates(this._attributes);
        if (previousResult != null && savedVar != null) {
            String relName = ctx.template(this._name);
            TaskResultIterator previousResultIt = previousResult.iterator();
            Object iter = previousResultIt.next();
            while (iter != null) {
                if (iter instanceof BaseNode) {
                    TaskResultIterator savedVarIt = savedVar.iterator();
                    Object toAddIter = savedVarIt.next();
                    while (toAddIter != null) {
                        if (toAddIter instanceof BaseNode) {
                            Node castedToAddIter = (Node)toAddIter;
                            Node castedIter = (Node)iter;
                            if (this._isAdd) {
                                castedIter.addToRelation(relName, castedToAddIter, templatedAttributes);
                            } else {
                                castedIter.removeFromRelation(relName, castedToAddIter, templatedAttributes);
                            }
                        }
                        toAddIter = savedVarIt.next();
                    }
                }
                iter = previousResultIt.next();
            }
        }
        ctx.continueTask();
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._isAdd) {
            builder.writeString(CoreActionNames.ADD_VAR_TO_RELATION);
        } else {
            builder.writeString(CoreActionNames.REMOVE_VAR_TO_RELATION);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeString(this._varFrom, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeStringParams(this._attributes, builder);
        builder.writeChar(')');
    }
}

