/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.Type;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.plugin.NodeState;
import greycat.plugin.NodeStateCallback;
import greycat.struct.Buffer;

class ActionAttributes
implements Action {
    private final byte _filter;

    ActionAttributes(String filterType) {
        this._filter = filterType != null ? Type.typeFromName(filterType) : (byte)-1;
    }

    @Override
    public void eval(final TaskContext ctx) {
        TaskResult previous = ctx.result();
        final TaskResult result = ctx.newResult();
        for (int i = 0; i < previous.size(); ++i) {
            if (!(previous.get(i) instanceof BaseNode)) continue;
            Node n = (Node)previous.get(i);
            NodeState nState = ctx.graph().resolver().resolveState(n);
            nState.each(new NodeStateCallback(){

                @Override
                public void on(int attributeKey, byte elemType, Object elem) {
                    if (ActionAttributes.this._filter == -1 || elemType == ActionAttributes.this._filter) {
                        String retrieved = ctx.graph().resolver().hashToString(attributeKey);
                        if (retrieved != null) {
                            result.add(retrieved);
                        } else {
                            result.add(attributeKey);
                        }
                    }
                }
            });
            n.free();
        }
        previous.clear();
        ctx.continueWith(result);
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._filter == -1) {
            builder.writeString(CoreActionNames.ATTRIBUTES);
            builder.writeChar('(');
            builder.writeChar(')');
        } else {
            builder.writeString(CoreActionNames.ATTRIBUTES_WITH_TYPE);
            builder.writeChar('(');
            TaskHelper.serializeType(this._filter, builder);
            builder.writeChar(')');
        }
    }
}

