/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionCreateNode
implements Action {
    private final String _typeNode;

    ActionCreateNode(String typeNode) {
        this._typeNode = typeNode;
    }

    @Override
    public void eval(TaskContext ctx) {
        Node newNode;
        if (this._typeNode == null) {
            newNode = ctx.graph().newNode(ctx.world(), ctx.time());
        } else {
            String templatedType = ctx.template(this._typeNode);
            newNode = ctx.graph().newTypedNode(ctx.world(), ctx.time(), templatedType);
        }
        ctx.continueWith(ctx.wrap(newNode));
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._typeNode == null) {
            builder.writeString(CoreActionNames.CREATE_NODE);
            builder.writeChar('(');
            builder.writeChar(')');
        } else {
            builder.writeString(CoreActionNames.CREATE_TYPED_NODE);
            builder.writeChar('(');
            TaskHelper.serializeString(this._typeNode, builder, true);
            builder.writeChar(')');
        }
    }
}

