/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.Tasks;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionDeclareVar
implements Action {
    private final String _name;
    private final boolean _isGlobal;

    ActionDeclareVar(boolean isGlobal, String p_name) {
        if (p_name == null) {
            throw new RuntimeException("name should not be null");
        }
        this._name = p_name;
        this._isGlobal = isGlobal;
    }

    @Override
    public final void eval(TaskContext ctx) {
        if (this._isGlobal) {
            ctx.setGlobalVariable(ctx.template(this._name), Tasks.emptyResult());
        } else {
            ctx.declareVariable(ctx.template(this._name));
        }
        ctx.continueTask();
    }

    @Override
    public final void serialize(Buffer builder) {
        if (this._isGlobal) {
            builder.writeString(CoreActionNames.DECLARE_GLOBAL_VAR);
        } else {
            builder.writeString(CoreActionNames.DECLARE_VAR);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(')');
    }
}

