/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionDefineAsVar
implements Action {
    private final String _name;
    private final boolean _global;

    ActionDefineAsVar(String p_name, boolean p_global) {
        if (p_name == null) {
            throw new RuntimeException("name should not be null");
        }
        this._name = p_name;
        this._global = p_global;
    }

    @Override
    public void eval(TaskContext ctx) {
        if (this._global) {
            ctx.setGlobalVariable(ctx.template(this._name), ctx.result());
        } else {
            ctx.defineVariable(ctx.template(this._name), ctx.result());
        }
        ctx.continueTask();
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._global) {
            builder.writeString(CoreActionNames.DEFINE_AS_GLOBAL_VAR);
        } else {
            builder.writeString(CoreActionNames.DEFINE_AS_VAR);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(')');
    }
}

