/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.internal.task.math.CoreMathExpressionEngine;
import greycat.internal.task.math.MathExpressionEngine;
import greycat.struct.Buffer;
import java.util.HashMap;

class ActionExecuteExpression
implements Action {
    private final MathExpressionEngine _engine;
    private final String _expression;

    ActionExecuteExpression(String mathExpression) {
        this._expression = mathExpression;
        this._engine = CoreMathExpressionEngine.parse(mathExpression);
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previous = ctx.result();
        TaskResult next = ctx.newResult();
        int previousSize = previous.size();
        for (int i = 0; i < previousSize; ++i) {
            Object loop = previous.get(i);
            HashMap<String, Double> variables = new HashMap<String, Double>();
            variables.put("PI", Math.PI);
            variables.put("TRUE", 1.0);
            variables.put("FALSE", 0.0);
            if (loop instanceof BaseNode) {
                next.add(this._engine.eval((Node)loop, ctx, variables));
                ((BaseNode)loop).free();
                continue;
            }
            next.add(this._engine.eval(null, ctx, variables));
        }
        previous.clear();
        ctx.continueWith(next);
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.EXECUTE_EXPRESSION);
        builder.writeChar('(');
        TaskHelper.serializeString(this._expression, builder, true);
        builder.writeChar(')');
    }
}

