/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionFlipVar
implements Action {
    private final String _name;

    ActionFlipVar(String name) {
        if (name == null) {
            throw new RuntimeException("name should not be null");
        }
        this._name = name;
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previousGlobalVar = ctx.variable(this._name);
        TaskResult nextResult = previousGlobalVar.clone();
        previousGlobalVar.fillWith(ctx.result());
        ctx.continueWith(nextResult);
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.FLIP_VAR);
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(')');
    }
}

