/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.NodeIndex;
import greycat.TaskContext;
import greycat.internal.task.CoreActionNames;
import greycat.struct.Buffer;

class ActionGlobalIndex
implements Action {
    private final String _name;

    ActionGlobalIndex(String p_indexName) {
        if (p_indexName == null) {
            throw new RuntimeException("indexName should not be null");
        }
        this._name = p_indexName;
    }

    @Override
    public void eval(final TaskContext ctx) {
        String name = ctx.template(this._name);
        ctx.graph().indexIfExists(ctx.world(), ctx.time(), name, new Callback<NodeIndex>(){

            @Override
            public void on(NodeIndex resolvedIndex) {
                if (resolvedIndex != null) {
                    ctx.continueWith(ctx.wrap(resolvedIndex));
                } else {
                    ctx.continueWith(ctx.newResult());
                }
            }
        });
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.GLOBAL_INDEX);
        builder.writeChar('(');
        builder.writeChar(')');
    }
}

