/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.Node;
import greycat.TaskContext;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionLookupAll
implements Action {
    private final String _ids;

    ActionLookupAll(String p_ids) {
        this._ids = p_ids;
    }

    @Override
    public void eval(final TaskContext ctx) {
        String afterTemplate = ctx.template(this._ids).trim();
        if (afterTemplate.startsWith("[")) {
            afterTemplate = afterTemplate.substring(1, afterTemplate.length() - 1);
        }
        String[] values = afterTemplate.split(",");
        long[] ids = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            ids[i] = Long.parseLong(values[i]);
        }
        ctx.graph().lookupAll(ctx.world(), ctx.time(), ids, new Callback<Node[]>(){

            @Override
            public void on(Node[] result) {
                ctx.continueWith(ctx.wrap(result));
            }
        });
    }

    @Override
    public final void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.LOOKUP_ALL);
        builder.writeChar('(');
        TaskHelper.serializeString(this._ids, builder, true);
        builder.writeChar(')');
    }
}

