/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionPrint
implements Action {
    private final String _name;
    private final boolean _withLineBreak;

    ActionPrint(String p_name, boolean withLineBreak) {
        this._name = p_name;
        this._withLineBreak = withLineBreak;
    }

    @Override
    public void eval(TaskContext ctx) {
        if (this._withLineBreak) {
            ctx.append(ctx.template(this._name) + '\n');
        } else {
            ctx.append(ctx.template(this._name));
        }
        ctx.continueTask();
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._withLineBreak) {
            builder.writeString(CoreActionNames.PRINTLN);
        } else {
            builder.writeString(CoreActionNames.PRINT);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(')');
    }
}

