/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.DeferCounter;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.internal.task.CoreActionNames;
import greycat.internal.tree.KDTree;
import greycat.internal.tree.NDTree;
import greycat.plugin.Job;
import greycat.struct.Buffer;
import greycat.struct.Tree;
import greycat.struct.TreeResult;

public class ActionQueryBoundedRadius
implements Action {
    public static String NAME = "QueryBoundedRadius";
    private final double[] _key;
    private final int _n;
    private final double _radius;
    private final boolean _fetchNodes;

    public ActionQueryBoundedRadius(int n, double radius, boolean fetchNodes, double[] key) {
        this._key = key;
        this._n = n;
        this._radius = radius;
        this._fetchNodes = fetchNodes;
    }

    @Override
    public final void eval(final TaskContext ctx) {
        TaskResult previousResult = ctx.result();
        final TaskResult nextResult = ctx.newResult();
        if (previousResult != null) {
            DeferCounter defer = ctx.graph().newCounter(previousResult.size());
            TaskResultIterator previousResultIt = previousResult.iterator();
            Object iter = previousResultIt.next();
            while (iter != null) {
                if (iter instanceof NDTree || iter instanceof KDTree) {
                    TreeResult tr = ((Tree)iter).queryBoundedRadius(this._key, this._radius, this._n);
                    if (this._fetchNodes) {
                        long[] nodeIds = new long[tr.size()];
                        for (int i = 0; i < tr.size(); ++i) {
                            nodeIds[i] = tr.value(i);
                        }
                        ctx.graph().lookupAll(ctx.world(), ctx.time(), nodeIds, result -> {
                            for (int j = 0; j < ((Node[])result).length; ++j) {
                                TaskResult line = ctx.newResult();
                                line.add(tr.keys(j));
                                line.add(result[j]);
                                line.add(tr.distance(j));
                                nextResult.add(line);
                            }
                            tr.free();
                            defer.count();
                        });
                    } else {
                        for (int i = 0; i < tr.size(); ++i) {
                            TaskResult line = ctx.newResult();
                            line.add(tr.keys(i));
                            line.add(tr.value(i));
                            line.add(tr.distance(i));
                            nextResult.add(line);
                        }
                        tr.free();
                        defer.count();
                    }
                } else {
                    defer.count();
                }
                iter = previousResultIt.next();
            }
            defer.then(new Job(){

                @Override
                public void run() {
                    ctx.continueWith(nextResult);
                }
            });
        } else {
            ctx.continueWith(nextResult);
        }
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.READ_GLOBAL_INDEX);
        builder.writeChar('(');
        builder.writeString("" + this._n);
        builder.writeChar(',');
        builder.writeString("" + this._radius);
        builder.writeChar(',');
        builder.writeString("" + this._fetchNodes);
        if (this._key != null && this._key.length > 0) {
            for (int i = 0; i < this._key.length; ++i) {
                builder.writeChar(',');
                builder.writeString("" + this._key[i]);
            }
        }
        builder.writeChar(')');
    }
}

