/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.Node;
import greycat.NodeIndex;
import greycat.TaskContext;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionReadGlobalIndex
implements Action {
    private final String _name;
    private final String[] _params;

    ActionReadGlobalIndex(String p_indexName, String ... p_query) {
        if (p_indexName == null) {
            throw new RuntimeException("indexName should not be null");
        }
        this._name = p_indexName;
        this._params = p_query;
    }

    @Override
    public void eval(final TaskContext ctx) {
        String name = ctx.template(this._name);
        final String[] query = ctx.templates(this._params);
        ctx.graph().indexIfExists(ctx.world(), ctx.time(), name, new Callback<NodeIndex>(){

            @Override
            public void on(final NodeIndex resolvedIndex) {
                if (resolvedIndex != null) {
                    resolvedIndex.find(new Callback<Node[]>(){

                        @Override
                        public void on(Node[] result) {
                            resolvedIndex.free();
                            ctx.continueWith(ctx.wrap(result));
                        }
                    }, query);
                } else {
                    ctx.continueWith(ctx.newResult());
                }
            }
        });
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.READ_GLOBAL_INDEX);
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        if (this._params != null && this._params.length > 0) {
            builder.writeChar(',');
            TaskHelper.serializeStringParams(this._params, builder);
        }
        builder.writeChar(')');
    }
}

