/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionReadVar
implements Action {
    private final String _origin;
    private final String _name;
    private final int _index;

    ActionReadVar(String p_name) {
        this._origin = p_name;
        int indexEnd = -1;
        int indexStart = -1;
        for (int cursor = p_name.length() - 1; cursor > 0; --cursor) {
            char c = p_name.charAt(cursor);
            if (c == ']') {
                indexEnd = cursor;
                continue;
            }
            if (c != '[') continue;
            indexStart = cursor + 1;
        }
        if (indexEnd != -1 && indexStart != -1) {
            this._index = TaskHelper.parseInt(p_name.substring(indexStart, indexEnd));
            this._name = p_name.substring(0, indexStart - 1);
        } else {
            this._index = -1;
            this._name = p_name;
        }
    }

    @Override
    public void eval(TaskContext ctx) {
        String evaluatedName = ctx.template(this._name);
        TaskResult varResult = this._index != -1 ? ctx.wrap(ctx.variable(evaluatedName).get(this._index)) : ctx.variable(evaluatedName);
        varResult = varResult != null ? varResult.clone() : ctx.newResult();
        ctx.continueWith(varResult);
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.READ_VAR);
        builder.writeChar('(');
        TaskHelper.serializeString(this._origin, builder, true);
        builder.writeChar(')');
    }
}

