/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import greycat.utility.Tuple;
import java.io.IOException;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

class ActionScript
implements Action {
    private final String _script;
    private final boolean _async;

    ActionScript(String script, boolean async) {
        this._script = script;
        this._async = async;
    }

    @Override
    public void eval(final TaskContext ctx) {
        SimpleScriptContext scriptCtx = new SimpleScriptContext();
        Tuple<String, TaskResult>[] variables = ctx.variables();
        for (int i = 0; i < variables.length; ++i) {
            scriptCtx.setAttribute(variables[i].left(), variables[i].right(), 100);
        }
        scriptCtx.setWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                ctx.append(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        scriptCtx.setAttribute("ctx", ctx, 100);
        scriptCtx.setAttribute("result", ctx.result(), 100);
        try {
            Object result = TaskHelper.SCRIPT_ENGINE.eval(this._script, (ScriptContext)scriptCtx);
            if (!this._async) {
                if (result != null) {
                    ctx.continueWith(ctx.wrap(result));
                } else {
                    ctx.continueTask();
                }
            }
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._async) {
            builder.writeString(CoreActionNames.ASYNC_SCRIPT);
        } else {
            builder.writeString(CoreActionNames.SCRIPT);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._script, builder, true);
        builder.writeChar(')');
    }
}

