/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskFunctionSelect;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

class ActionSelect
implements Action {
    private final String _script;
    private final TaskFunctionSelect _filter;

    ActionSelect(String script, TaskFunctionSelect filter) {
        this._script = script;
        this._filter = filter;
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previous = ctx.result();
        TaskResult next = ctx.newResult();
        int previousSize = previous.size();
        for (int i = 0; i < previousSize; ++i) {
            Object obj = previous.get(i);
            if (obj instanceof BaseNode) {
                Node casted = (Node)obj;
                if (this._filter != null && this._filter.select(casted, ctx)) {
                    next.add(casted);
                    continue;
                }
                if (this._script != null && this.callScript(casted, ctx)) {
                    next.add(casted);
                    continue;
                }
                casted.free();
                continue;
            }
            next.add(obj);
        }
        previous.clear();
        ctx.continueWith(next);
    }

    private boolean callScript(Node node, TaskContext context) {
        SimpleScriptContext scriptCtx = new SimpleScriptContext();
        scriptCtx.setAttribute("node", node, 100);
        scriptCtx.setAttribute("context", context, 100);
        try {
            return (Boolean)TaskHelper.SCRIPT_ENGINE.eval(this._script, (ScriptContext)scriptCtx);
        }
        catch (ClassCastException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._script == null) {
            throw new RuntimeException("Select remote usage not managed yet, please use SelectScript instead !");
        }
        builder.writeString(CoreActionNames.SELECT);
        builder.writeChar('(');
        TaskHelper.serializeString(this._script, builder, true);
        builder.writeChar(')');
    }
}

