/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskFunctionSelectObject;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.base.BaseNode;
import greycat.struct.Buffer;

class ActionSelectObject
implements Action {
    private final TaskFunctionSelectObject _filter;

    ActionSelectObject(TaskFunctionSelectObject filterFunction) {
        if (filterFunction == null) {
            throw new RuntimeException("filterFunction should not be null");
        }
        this._filter = filterFunction;
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previous = ctx.result();
        TaskResult next = ctx.wrap(null);
        TaskResultIterator iterator = previous.iterator();
        Object nextElem = iterator.next();
        while (nextElem != null) {
            if (this._filter.select(nextElem, ctx)) {
                if (nextElem instanceof BaseNode) {
                    Node casted = (Node)nextElem;
                    next.add(casted.graph().cloneNode(casted));
                } else {
                    next.add(nextElem);
                }
            }
            nextElem = iterator.next();
        }
        ctx.continueWith(next);
    }

    @Override
    public void serialize(Buffer builder) {
        throw new RuntimeException("SelectObject remote usage not managed yet, please use SelectScript instead !");
    }

    public String toString() {
        return "selectObject()";
    }
}

