/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.Type;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;

class ActionSetAttribute
implements Action {
    private final String _name;
    private final String _value;
    private final byte _propertyType;
    private final boolean _force;

    ActionSetAttribute(String name, String propertyType, String value, boolean force) {
        this._name = name;
        this._value = value;
        this._propertyType = Type.typeFromName(propertyType);
        this._force = force;
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previousResult = ctx.result();
        String flatRelationName = ctx.template(this._name);
        if (previousResult != null) {
            Object toSet;
            String valueAfterTemplate = ctx.template(this._value);
            switch (this._propertyType) {
                case 1: {
                    toSet = this.parseBoolean(valueAfterTemplate);
                    break;
                }
                case 4: {
                    toSet = TaskHelper.parseInt(valueAfterTemplate);
                    break;
                }
                case 5: {
                    toSet = Double.parseDouble(valueAfterTemplate);
                    break;
                }
                case 3: {
                    toSet = Long.parseLong(valueAfterTemplate);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    try {
                        toSet = this.loadArray(valueAfterTemplate, this._propertyType);
                    }
                    catch (NumberFormatException e) {
                        toSet = null;
                        ctx.endTask(null, new Exception("Error while parsing array from string:\"" + valueAfterTemplate + "\"\n" + e.toString()));
                    }
                    break;
                }
                default: {
                    toSet = valueAfterTemplate;
                }
            }
            for (int i = 0; i < previousResult.size(); ++i) {
                Object loopObj = previousResult.get(i);
                if (!(loopObj instanceof BaseNode)) continue;
                Node loopNode = (Node)loopObj;
                if (this._force) {
                    loopNode.forceSet(flatRelationName, this._propertyType, toSet);
                    continue;
                }
                loopNode.set(flatRelationName, this._propertyType, toSet);
            }
        }
        ctx.continueTask();
    }

    private Object loadArray(String valueAfterTemplate, byte type) throws NumberFormatException {
        String arrayInString = valueAfterTemplate;
        if (arrayInString.charAt(0) == '[') {
            arrayInString = arrayInString.substring(1);
        }
        if (arrayInString.charAt(arrayInString.length() - 1) == ']') {
            arrayInString = arrayInString.substring(0, arrayInString.length() - 1);
        }
        String[] valuesToParse = arrayInString.split(",");
        switch (type) {
            case 6: {
                double[] finalValues = new double[valuesToParse.length];
                for (int i = 0; i < valuesToParse.length; ++i) {
                    finalValues[i] = Double.parseDouble(valuesToParse[i]);
                }
                return finalValues;
            }
            case 7: {
                long[] finalValues = new long[valuesToParse.length];
                for (int i = 0; i < valuesToParse.length; ++i) {
                    finalValues[i] = Long.parseLong(valuesToParse[i]);
                }
                return finalValues;
            }
            case 8: {
                int[] finalValues = new int[valuesToParse.length];
                for (int i = 0; i < valuesToParse.length; ++i) {
                    finalValues[i] = Integer.parseInt(valuesToParse[i]);
                }
                return finalValues;
            }
        }
        return null;
    }

    private boolean parseBoolean(String booleanValue) {
        String lower = booleanValue.toLowerCase();
        return lower.equals("true") || lower.equals("1");
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._force) {
            builder.writeString(CoreActionNames.FORCE_ATTRIBUTE);
        } else {
            builder.writeString(CoreActionNames.SET_ATTRIBUTE);
        }
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeType(this._propertyType, builder);
        builder.writeChar(',');
        TaskHelper.serializeString(this._value, builder, true);
        builder.writeChar(')');
    }
}

