/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.struct.Buffer;

class ActionTimeSensitivity
implements Action {
    private final String _delta;
    private final String _offset;

    ActionTimeSensitivity(String delta, String offset) {
        this._delta = delta;
        this._offset = offset;
    }

    @Override
    public void eval(TaskContext ctx) {
        TaskResult previousResult = ctx.result();
        long parsedDelta = Long.parseLong(ctx.template(this._delta));
        long parsedOffset = Long.parseLong(ctx.template(this._offset));
        for (int i = 0; i < previousResult.size(); ++i) {
            Object loopObj = previousResult.get(i);
            if (!(loopObj instanceof BaseNode)) continue;
            Node loopNode = (Node)loopObj;
            loopNode.setTimeSensitivity(parsedDelta, parsedOffset);
        }
        ctx.continueTask();
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.SET_ATTRIBUTE);
        builder.writeChar('(');
        builder.writeString(this._delta);
        builder.writeChar(',');
        builder.writeString(this._offset);
        builder.writeChar(')');
    }
}

