/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.CoreDeferCounter;
import greycat.internal.task.CoreActionNames;
import greycat.plugin.Job;
import greycat.struct.Buffer;

class ActionTimepoints
implements Action {
    private final String _from;
    private final String _to;

    ActionTimepoints(String from, String to) {
        this._from = from;
        this._to = to;
    }

    @Override
    public void eval(final TaskContext ctx) {
        long parsedTo;
        Double d;
        long parsedFrom;
        final TaskResult previous = ctx.result();
        String tFrom = ctx.template(this._from);
        String tTo = ctx.template(this._to);
        try {
            parsedFrom = Long.parseLong(tFrom);
        }
        catch (Throwable t) {
            d = Double.parseDouble(tFrom);
            parsedFrom = d.longValue();
        }
        try {
            parsedTo = Long.parseLong(tTo);
        }
        catch (Throwable t) {
            d = Double.parseDouble(tTo);
            parsedTo = d.longValue();
        }
        final TaskResult next = ctx.newResult();
        if (previous != null) {
            final CoreDeferCounter defer = new CoreDeferCounter(previous.size());
            for (int i = 0; i < previous.size(); ++i) {
                if (!(previous.get(i) instanceof BaseNode)) continue;
                final Node casted = (Node)previous.get(i);
                casted.timepoints(parsedFrom, parsedTo, new Callback<long[]>(){

                    @Override
                    public void on(long[] result) {
                        for (int i = 0; i < result.length; ++i) {
                            next.add(result[i]);
                        }
                        casted.free();
                        defer.count();
                    }
                });
            }
            defer.then(new Job(){

                @Override
                public void run() {
                    previous.clear();
                    ctx.continueWith(next);
                }
            });
        } else {
            ctx.continueWith(next);
        }
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.TIMEPOINTS);
        builder.writeChar('(');
        builder.writeChar(')');
    }
}

