/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.struct.Buffer;

class ActionTravelInWorld
implements Action {
    private final String _world;

    ActionTravelInWorld(String world) {
        this._world = world;
    }

    @Override
    public void eval(final TaskContext ctx) {
        long parsedWorld;
        String flatWorld = ctx.template(this._world);
        try {
            parsedWorld = Long.parseLong(flatWorld);
        }
        catch (Throwable t) {
            Double d = Double.parseDouble(flatWorld);
            parsedWorld = d.longValue();
        }
        ctx.setWorld(parsedWorld);
        final TaskResult previous = ctx.result();
        int previousSize = previous.size();
        long[] worlds = new long[previousSize];
        long[] times = new long[previousSize];
        long[] ids = new long[previousSize];
        final int[] indexes = new int[previousSize];
        int index = 0;
        for (int i = 0; i < previousSize; ++i) {
            Node casted;
            Object loopObj = previous.get(i);
            if (!(loopObj instanceof BaseNode) || parsedWorld == (casted = (Node)loopObj).world()) continue;
            worlds[index] = parsedWorld;
            times[index] = casted.time();
            ids[index] = casted.id();
            indexes[index] = i;
            ++index;
            casted.free();
        }
        if (index == 0) {
            ctx.continueTask();
        } else {
            if (index != previousSize) {
                long[] new_worlds = new long[index];
                System.arraycopy(new_worlds, 0, worlds, 0, index);
                worlds = new_worlds;
                long[] new_times = new long[index];
                System.arraycopy(new_times, 0, times, 0, index);
                times = new_times;
                long[] new_ids = new long[index];
                System.arraycopy(new_ids, 0, ids, 0, index);
                ids = new_ids;
            }
            ctx.graph().resolver().lookupBatch(worlds, times, ids, new Callback<Node[]>(){

                @Override
                public void on(Node[] result) {
                    for (int i = 0; i < result.length; ++i) {
                        previous.set(indexes[i], result[i]);
                    }
                    ctx.continueTask();
                }
            });
        }
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.TRAVEL_IN_TIME);
        builder.writeChar('(');
        builder.writeString(this._world);
        builder.writeChar(')');
    }
}

