/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.Constants;
import greycat.Node;
import greycat.Query;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.plugin.NodeState;
import greycat.plugin.Resolver;
import greycat.struct.Buffer;
import greycat.struct.Relation;
import greycat.struct.RelationIndexed;
import greycat.utility.LongArray;

class ActionTraverseOrAttribute
implements Action {
    private final String _name;
    private final String[] _params;
    private final boolean _isAttribute;
    private final boolean _isUnknown;

    ActionTraverseOrAttribute(boolean isAttribute, boolean isUnknown, String p_name, String ... p_params) {
        this._name = p_name;
        this._params = p_params;
        this._isUnknown = isUnknown;
        this._isAttribute = isAttribute;
    }

    @Override
    public final void eval(final TaskContext ctx) {
        final Resolver resolver = ctx.graph().resolver();
        final TaskResult finalResult = ctx.newResult();
        String flatName = ctx.template(this._name);
        final TaskResult previousResult = ctx.result();
        if (previousResult != null) {
            Query query;
            int previousSize = previousResult.size();
            LongArray worlds = new LongArray();
            LongArray times = new LongArray();
            LongArray ids = new LongArray();
            if (this._params != null && this._params.length > 0) {
                query = ctx.graph().newQuery();
                String previous = null;
                for (int k = 0; k < this._params.length; ++k) {
                    if (previous != null) {
                        query.add(previous, ctx.template(this._params[k]));
                        previous = null;
                        continue;
                    }
                    previous = this._params[k];
                }
            } else {
                query = null;
            }
            for (int i = 0; i < previousSize; ++i) {
                Object loop = previousResult.get(i);
                if (loop instanceof BaseNode) {
                    Node casted = (Node)loop;
                    switch (casted.type(flatName)) {
                        case 13: {
                            Relation relation = (Relation)casted.get(flatName);
                            if (relation == null) break;
                            int relSize = relation.size();
                            for (int k = 0; k < relSize; ++k) {
                                worlds.add(casted.world());
                                times.add(casted.time());
                                ids.add(relation.get(k));
                            }
                            break;
                        }
                        case 14: {
                            int k;
                            RelationIndexed relationIndexed = (RelationIndexed)casted.get(flatName);
                            if (relationIndexed == null) break;
                            if (query != null) {
                                long[] candidates = relationIndexed.selectByQuery(query);
                                for (k = 0; k < candidates.length; ++k) {
                                    worlds.add(casted.world());
                                    times.add(casted.time());
                                    ids.add(candidates[k]);
                                }
                            } else {
                                int relSize = relationIndexed.size();
                                for (k = 0; k < relSize; ++k) {
                                    worlds.add(casted.world());
                                    times.add(casted.time());
                                    ids.add(relationIndexed.getByIndex(k));
                                }
                            }
                            break;
                        }
                        default: {
                            Object resolved = casted.get(flatName);
                            if (resolved == null) break;
                            finalResult.add(resolved);
                        }
                    }
                    casted.free();
                    continue;
                }
                finalResult.add(loop);
            }
            if (ids.size() == 0) {
                previousResult.clear();
                ctx.continueWith(finalResult);
            } else {
                resolver.lookupBatch(worlds.all(), times.all(), ids.all(), new Callback<Node[]>(){

                    @Override
                    public void on(Node[] result) {
                        for (int i = 0; i < result.length; ++i) {
                            Node resolvedNode = result[i];
                            if (resolvedNode == null) continue;
                            if (query == null) {
                                finalResult.add(resolvedNode);
                                continue;
                            }
                            NodeState resolvedState = resolver.resolveState(resolvedNode);
                            boolean exact = true;
                            for (int j = 0; j < query.attributes().length; ++j) {
                                Object obj = resolvedState.getAt(query.attributes()[j]);
                                if (query.values()[j] == null) {
                                    if (obj == null) continue;
                                    exact = false;
                                    break;
                                }
                                if (obj == null) {
                                    exact = false;
                                    break;
                                }
                                if (obj instanceof long[]) {
                                    if (query.values()[j] instanceof long[]) {
                                        if (Constants.longArrayEquals((long[])query.values()[j], (long[])obj)) continue;
                                        exact = false;
                                        break;
                                    }
                                    exact = false;
                                    break;
                                }
                                if (Constants.equals(query.values()[j].toString(), obj.toString())) continue;
                                exact = false;
                                break;
                            }
                            if (!exact) continue;
                            finalResult.add(resolvedNode);
                        }
                        previousResult.clear();
                        ctx.continueWith(finalResult);
                    }
                });
            }
        } else {
            ctx.continueTask();
        }
    }

    @Override
    public void serialize(Buffer builder) {
        if (this._isUnknown) {
            builder.writeString(this._name);
        } else if (this._isAttribute) {
            builder.writeString(CoreActionNames.ATTRIBUTE);
            builder.writeChar('(');
            builder.writeString(this._name);
            builder.writeChar(')');
        } else {
            builder.writeString(CoreActionNames.TRAVERSE);
            builder.writeChar('(');
            builder.writeString(this._name);
            if (this._params != null && this._params.length > 0) {
                builder.writeChar(',');
                TaskHelper.serializeStringParams(this._params, builder);
            }
            builder.writeChar(')');
        }
    }
}

