/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import java.util.regex.Pattern;

class ActionWith
implements Action {
    private final String _patternTemplate;
    private final String _name;

    ActionWith(String name, String stringPattern) {
        if (name == null) {
            throw new RuntimeException("name should not be null");
        }
        if (stringPattern == null) {
            throw new RuntimeException("pattern should not be null");
        }
        this._patternTemplate = stringPattern;
        this._name = name;
    }

    @Override
    public void eval(TaskContext ctx) {
        Pattern pattern = Pattern.compile(ctx.template(this._patternTemplate));
        TaskResult previous = ctx.result();
        TaskResult next = ctx.newResult();
        int previousSize = previous.size();
        for (int i = 0; i < previousSize; ++i) {
            Object obj = previous.get(i);
            if (obj instanceof BaseNode) {
                Node casted = (Node)obj;
                Object currentName = casted.get(this._name);
                if (currentName == null || !pattern.matcher(currentName.toString()).matches()) continue;
                next.add(casted.graph().cloneNode(casted));
                continue;
            }
            next.add(obj);
        }
        ctx.continueWith(next);
    }

    @Override
    public void serialize(Buffer builder) {
        builder.writeString(CoreActionNames.WITH);
        builder.writeChar('(');
        TaskHelper.serializeString(this._name, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeString(this._patternTemplate, builder, true);
        builder.writeChar(')');
    }
}

