/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.Node;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.base.BaseNode;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.plugin.Resolver;
import greycat.struct.Buffer;
import java.util.ArrayList;
import java.util.Map;

public class CF_Atomic
extends CF_Action {
    private final String[] _variables;
    private final Task _subTask;

    CF_Atomic(Task p_subTask, String ... variables) {
        this._subTask = p_subTask;
        this._variables = variables;
    }

    @Override
    public void eval(final TaskContext ctx) {
        final ArrayList<TaskResult> collected = new ArrayList<TaskResult>();
        for (int i = 0; i < this._variables.length; ++i) {
            String varName = this._variables[i];
            TaskResult resolved = varName.equals("result") ? ctx.result() : ctx.variable(varName);
            if (resolved == null) continue;
            collected.add(resolved);
        }
        final Resolver resolver = ctx.graph().resolver();
        for (int i = 0; i < collected.size(); ++i) {
            TaskResult toLock = (TaskResult)collected.get(i);
            for (int j = 0; j < toLock.size(); ++j) {
                Object o = toLock.get(j);
                if (!(o instanceof BaseNode)) continue;
                resolver.externalLock((Node)o);
            }
        }
        this._subTask.executeFrom(ctx, ctx.result(), (byte)0, new Callback<TaskResult>(){

            @Override
            public void on(TaskResult result) {
                Exception exceptionDuringTask = null;
                if (result != null) {
                    if (result.output() != null) {
                        ctx.append(result.output());
                    }
                    if (result.exception() != null) {
                        exceptionDuringTask = result.exception();
                    }
                }
                for (int i = 0; i < collected.size(); ++i) {
                    TaskResult toLock = (TaskResult)collected.get(i);
                    for (int j = 0; j < toLock.size(); ++j) {
                        Object o = toLock.get(j);
                        if (!(o instanceof BaseNode)) continue;
                        resolver.externalUnlock((Node)o);
                    }
                }
                if (exceptionDuringTask != null) {
                    ctx.endTask(result, exceptionDuringTask);
                } else {
                    ctx.continueWith(result);
                }
            }
        });
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._subTask};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.ATOMIC);
        builder.writeChar('(');
        CoreTask castedAction = (CoreTask)this._subTask;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        for (int i = 0; i < this._variables.length; ++i) {
            builder.writeChar(',');
            TaskHelper.serializeString(this._variables[i], builder, true);
        }
        builder.writeChar(')');
    }
}

