/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.struct.Buffer;
import greycat.utility.Tuple;
import java.util.Map;

class CF_ForEach
extends CF_Action {
    private final Task _subTask;

    CF_ForEach(Task p_subTask) {
        this._subTask = p_subTask;
    }

    @Override
    public void eval(final TaskContext ctx) {
        final CF_ForEach selfPointer = this;
        TaskResult previousResult = ctx.result();
        if (previousResult == null) {
            ctx.continueTask();
        } else {
            Callback[] recursiveAction;
            final TaskResultIterator it = previousResult.iterator();
            recursiveAction = new Callback[]{new Callback<TaskResult>(){

                @Override
                public void on(TaskResult res) {
                    Tuple nextResult;
                    Exception exceptionDuringTask = null;
                    if (res != null) {
                        if (res.output() != null) {
                            ctx.append(res.output());
                        }
                        if (res.exception() != null) {
                            exceptionDuringTask = res.exception();
                        }
                        res.free();
                    }
                    if ((nextResult = it.nextWithIndex()) == null || exceptionDuringTask != null) {
                        if (exceptionDuringTask != null) {
                            ctx.endTask(null, exceptionDuringTask);
                        } else {
                            ctx.continueTask();
                        }
                    } else {
                        selfPointer._subTask.executeFromUsing(ctx, ctx.wrap(nextResult.right()), (byte)0, new Callback<TaskContext>(){

                            @Override
                            public void on(TaskContext result) {
                                result.defineVariable("i", nextResult.left());
                            }
                        }, recursiveAction[0]);
                    }
                }
            }};
            final Tuple nextRes = it.nextWithIndex();
            if (nextRes != null) {
                this._subTask.executeFromUsing(ctx, ctx.wrap(nextRes.right()), (byte)0, new Callback<TaskContext>(){

                    @Override
                    public void on(TaskContext result) {
                        result.defineVariable("i", nextRes.left());
                    }
                }, recursiveAction[0]);
            } else {
                ctx.continueTask();
            }
        }
    }

    @Override
    public final Task[] children() {
        Task[] children_tasks = new Task[]{this._subTask};
        return children_tasks;
    }

    @Override
    public final void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.FOR_EACH);
        builder.writeChar('(');
        CoreTask castedAction = (CoreTask)this._subTask;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

