/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.ConditionalFunction;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import java.util.Map;

class CF_IfThen
extends CF_Action {
    private ConditionalFunction _condition;
    private Task _action;
    private String _conditionalScript;

    CF_IfThen(ConditionalFunction cond, Task action, String conditionalScript) {
        if (cond == null) {
            throw new RuntimeException("condition should not be null");
        }
        if (action == null) {
            throw new RuntimeException("subTask should not be null");
        }
        this._conditionalScript = conditionalScript;
        this._condition = cond;
        this._action = action;
    }

    @Override
    public void eval(final TaskContext ctx) {
        if (this._condition.eval(ctx)) {
            this._action.executeFrom(ctx, ctx.result(), (byte)0, new Callback<TaskResult>(){

                @Override
                public void on(TaskResult res) {
                    Exception exceptionDuringTask = null;
                    if (res != null) {
                        if (res.output() != null) {
                            ctx.append(res.output());
                        }
                        if (res.exception() != null) {
                            exceptionDuringTask = res.exception();
                        }
                    }
                    if (exceptionDuringTask != null) {
                        ctx.endTask(res, exceptionDuringTask);
                    } else {
                        ctx.continueWith(res);
                    }
                }
            });
        } else {
            ctx.continueTask();
        }
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._action};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        if (this._conditionalScript == null) {
            throw new RuntimeException("Closure is not serializable, please use Script version instead!");
        }
        builder.writeString(CoreActionNames.IF_THEN);
        builder.writeChar('(');
        TaskHelper.serializeString(this._conditionalScript, builder, true);
        builder.writeChar(',');
        CoreTask castedAction = (CoreTask)this._action;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

