/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.ConditionalFunction;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import java.util.Map;

class CF_IfThenElse
extends CF_Action {
    private ConditionalFunction _condition;
    private Task _thenSub;
    private Task _elseSub;
    private String _conditionalScript;

    CF_IfThenElse(ConditionalFunction cond, Task p_thenSub, Task p_elseSub, String conditionalScript) {
        if (cond == null) {
            throw new RuntimeException("condition should not be null");
        }
        if (p_thenSub == null) {
            throw new RuntimeException("thenSub should not be null");
        }
        if (p_elseSub == null) {
            throw new RuntimeException("elseSub should not be null");
        }
        this._conditionalScript = conditionalScript;
        this._condition = cond;
        this._thenSub = p_thenSub;
        this._elseSub = p_elseSub;
    }

    @Override
    public void eval(final TaskContext ctx) {
        Task selectedNextTask = this._condition.eval(ctx) ? this._thenSub : this._elseSub;
        selectedNextTask.executeFrom(ctx, ctx.result(), (byte)0, new Callback<TaskResult>(){

            @Override
            public void on(TaskResult res) {
                Exception exceptionDuringTask = null;
                if (res != null) {
                    if (res.output() != null) {
                        ctx.append(res.output());
                    }
                    if (res.exception() != null) {
                        exceptionDuringTask = res.exception();
                    }
                }
                if (exceptionDuringTask != null) {
                    ctx.endTask(res, exceptionDuringTask);
                } else {
                    ctx.continueWith(res);
                }
            }
        });
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._thenSub, this._elseSub};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        if (this._conditionalScript == null) {
            throw new RuntimeException("Closure is not serializable, please use Script version instead!");
        }
        builder.writeString(CoreActionNames.IF_THEN_ELSE);
        builder.writeChar('(');
        TaskHelper.serializeString(this._conditionalScript, builder, true);
        builder.writeChar(',');
        CoreTask castedSubThen = (CoreTask)this._thenSub;
        int castedSubThenHash = castedSubThen.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedSubThenHash)) {
            builder.writeChar('{');
            castedSubThen.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedSubThenHash));
        }
        builder.writeChar(',');
        CoreTask castedSubElse = (CoreTask)this._elseSub;
        int castedSubElseHash = castedSubElse.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedSubElseHash)) {
            builder.writeChar('{');
            castedSubElse.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedSubElseHash));
        }
        builder.writeChar(')');
    }
}

