/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class CF_Loop
extends CF_Action {
    private final String _lower;
    private final String _upper;
    private final Task _subTask;

    CF_Loop(String p_lower, String p_upper, Task p_subTask) {
        this._subTask = p_subTask;
        this._lower = p_lower;
        this._upper = p_upper;
    }

    @Override
    public void eval(final TaskContext ctx) {
        String lowerString = ctx.template(this._lower);
        String upperString = ctx.template(this._upper);
        int lower = (int)Double.parseDouble(ctx.template(lowerString));
        final int upper = (int)Double.parseDouble(ctx.template(upperString));
        final TaskResult previous = ctx.result();
        final CF_Loop selfPointer = this;
        final AtomicInteger cursor = new AtomicInteger(lower);
        if (upper - lower >= 0) {
            Callback[] recursiveAction;
            recursiveAction = new Callback[]{new Callback<TaskResult>(){

                @Override
                public void on(TaskResult res) {
                    final int current = cursor.getAndIncrement();
                    Exception exceptionDuringTask = null;
                    if (res != null) {
                        if (res.output() != null) {
                            ctx.append(res.output());
                        }
                        if (res.exception() != null) {
                            exceptionDuringTask = res.exception();
                        }
                        res.free();
                    }
                    if (current > upper || exceptionDuringTask != null) {
                        if (exceptionDuringTask != null) {
                            ctx.endTask(null, exceptionDuringTask);
                        } else {
                            ctx.continueTask();
                        }
                    } else {
                        selfPointer._subTask.executeFromUsing(ctx, previous, (byte)0, new Callback<TaskContext>(){

                            @Override
                            public void on(TaskContext result) {
                                result.defineVariable("i", current);
                            }
                        }, recursiveAction[0]);
                    }
                }
            }};
            this._subTask.executeFromUsing(ctx, previous, (byte)0, new Callback<TaskContext>(){

                @Override
                public void on(TaskContext result) {
                    result.defineVariable("i", cursor.getAndIncrement());
                }
            }, recursiveAction[0]);
        } else {
            ctx.continueTask();
        }
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._subTask};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.LOOP);
        builder.writeChar('(');
        TaskHelper.serializeString(this._lower, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeString(this._upper, builder, true);
        builder.writeChar(',');
        CoreTask castedAction = (CoreTask)this._subTask;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

