/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.DeferCounter;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.plugin.Job;
import greycat.struct.Buffer;
import java.util.Map;

class CF_LoopPar
extends CF_Action {
    private final Task _subTask;
    private final String _lower;
    private final String _upper;

    CF_LoopPar(String p_lower, String p_upper, Task p_subTask) {
        this._subTask = p_subTask;
        this._lower = p_lower;
        this._upper = p_upper;
    }

    @Override
    public void eval(final TaskContext ctx) {
        String lowerString = ctx.template(this._lower);
        String upperString = ctx.template(this._upper);
        int lower = (int)Double.parseDouble(ctx.template(lowerString));
        int upper = (int)Double.parseDouble(ctx.template(upperString));
        TaskResult previous = ctx.result();
        final Exception[] exceptionDuringTask = new Exception[]{null};
        if (upper - lower > 0) {
            final DeferCounter waiter = ctx.graph().newCounter(upper - lower + 1);
            int i = lower;
            while (i <= upper) {
                final int finalI = i++;
                this._subTask.executeFromUsing(ctx, previous, (byte)1, new Callback<TaskContext>(){

                    @Override
                    public void on(TaskContext result) {
                        result.defineVariable("i", finalI);
                    }
                }, new Callback<TaskResult>(){

                    @Override
                    public void on(TaskResult result) {
                        if (result != null) {
                            if (result.output() != null) {
                                ctx.append(result.output());
                            }
                            if (result.exception() != null) {
                                exceptionDuringTask[0] = result.exception();
                            }
                            result.free();
                        }
                        waiter.count();
                    }
                });
            }
            waiter.then(new Job(){

                @Override
                public void run() {
                    if (exceptionDuringTask[0] != null) {
                        ctx.endTask(null, exceptionDuringTask[0]);
                    } else {
                        ctx.continueTask();
                    }
                }
            });
        } else {
            ctx.continueTask();
        }
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._subTask};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.LOOP_PAR);
        builder.writeChar('(');
        TaskHelper.serializeString(this._lower, builder, true);
        builder.writeChar(',');
        TaskHelper.serializeString(this._upper, builder, true);
        builder.writeChar(',');
        CoreTask castedAction = (CoreTask)this._subTask;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

