/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.DeferCounter;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.plugin.Job;
import greycat.struct.Buffer;
import greycat.utility.Tuple;
import java.util.Map;

class CF_MapPar
extends CF_Action {
    private final Task _subTask;

    CF_MapPar(Task p_subTask) {
        this._subTask = p_subTask;
    }

    @Override
    public void eval(final TaskContext ctx) {
        TaskResult previousResult = ctx.result();
        final TaskResult finalResult = ctx.wrap(null);
        final TaskResultIterator it = previousResult.iterator();
        int previousSize = previousResult.size();
        if (previousSize == -1) {
            throw new RuntimeException("Foreach on non array structure are not supported yet!");
        }
        finalResult.allocate(previousSize);
        final DeferCounter waiter = ctx.graph().newCounter(previousSize);
        final Job[] dequeueJob = new Job[1];
        final Exception[] exceptionDuringTask = new Exception[]{null};
        dequeueJob[0] = new Job(){

            @Override
            public void run() {
                final Tuple loop = it.nextWithIndex();
                if (loop != null) {
                    CF_MapPar.this._subTask.executeFromUsing(ctx, ctx.wrap(loop.right()), (byte)1, new Callback<TaskContext>(){

                        @Override
                        public void on(TaskContext result) {
                            result.defineVariable("i", loop.left());
                        }
                    }, new Callback<TaskResult>(){

                        @Override
                        public void on(TaskResult result) {
                            if (result != null) {
                                finalResult.add(result);
                                if (result.output() != null) {
                                    ctx.append(result.output());
                                }
                                if (result.exception() != null) {
                                    exceptionDuringTask[0] = result.exception();
                                }
                            }
                            waiter.count();
                            dequeueJob[0].run();
                        }
                    });
                }
            }
        };
        int nbThread = ctx.graph().scheduler().workers();
        for (int i = 0; i < nbThread; ++i) {
            dequeueJob[0].run();
        }
        waiter.then(new Job(){

            @Override
            public void run() {
                if (exceptionDuringTask[0] != null) {
                    ctx.endTask(finalResult, exceptionDuringTask[0]);
                } else {
                    ctx.continueWith(finalResult);
                }
            }
        });
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._subTask};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.MAP_PAR);
        builder.writeChar('(');
        CoreTask castedAction = (CoreTask)this._subTask;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

