/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.struct.Buffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class CF_Pipe
extends CF_Action {
    private final Task[] _subTasks;

    CF_Pipe(Task ... p_subTasks) {
        this._subTasks = p_subTasks;
    }

    @Override
    public void eval(final TaskContext ctx) {
        Callback[] loopcb;
        TaskResult next;
        final TaskResult previous = ctx.result();
        final AtomicInteger cursor = new AtomicInteger(0);
        final int tasksSize = this._subTasks.length;
        if (tasksSize > 1) {
            next = ctx.newResult();
            next.allocate(tasksSize);
        } else {
            next = null;
        }
        loopcb = new Callback[]{new Callback<TaskResult>(){

            @Override
            public void on(TaskResult result) {
                Exception exceptionDuringTask = null;
                int current = cursor.getAndIncrement();
                if (result != null) {
                    if (tasksSize > 1) {
                        next.add(result);
                    }
                    if (result.output() != null) {
                        ctx.append(result.output());
                    }
                    if (result.exception() != null) {
                        exceptionDuringTask = result.exception();
                    }
                }
                if (current < tasksSize && exceptionDuringTask == null) {
                    CF_Pipe.this._subTasks[current].executeFrom(ctx, previous, (byte)0, loopcb[0]);
                } else {
                    TaskResult nextResult = tasksSize > 1 ? next : result;
                    if (exceptionDuringTask != null) {
                        ctx.endTask(nextResult, exceptionDuringTask);
                    } else {
                        ctx.continueWith(nextResult);
                    }
                }
            }
        }};
        int current = cursor.getAndIncrement();
        if (current < tasksSize) {
            this._subTasks[current].executeFrom(ctx, previous, (byte)0, loopcb[0]);
        } else {
            ctx.continueWith(next);
        }
    }

    @Override
    public Task[] children() {
        return this._subTasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.PIPE);
        builder.writeChar('(');
        for (int i = 0; i < this._subTasks.length; ++i) {
            if (i != 0) {
                builder.writeChar(',');
            }
            CoreTask castedAction = (CoreTask)this._subTasks[i];
            int castedActionHash = castedAction.hashCode();
            if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
                builder.writeChar('{');
                castedAction.serialize(builder, dagIDS);
                builder.writeChar('}');
                continue;
            }
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

