/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.DeferCounter;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.plugin.Job;
import greycat.struct.Buffer;
import java.util.Map;

class CF_PipePar
extends CF_Action {
    private final Task[] _subTasks;

    CF_PipePar(Task ... p_subTasks) {
        this._subTasks = p_subTasks;
    }

    @Override
    public void eval(final TaskContext ctx) {
        TaskResult previous = ctx.result();
        final int subTasksSize = this._subTasks.length;
        final TaskResult next = ctx.newResult();
        next.allocate(subTasksSize);
        final DeferCounter waiter = ctx.graph().newCounter(subTasksSize);
        final Exception[] exceptionDuringTask = new Exception[]{null};
        for (int i = 0; i < subTasksSize; ++i) {
            final int finalI = i;
            this._subTasks[i].executeFrom(ctx, previous, (byte)1, new Callback<TaskResult>(){

                @Override
                public void on(TaskResult subTaskResult) {
                    if (subTaskResult != null) {
                        if (subTaskResult.output() != null) {
                            ctx.append(subTaskResult.output());
                        }
                        if (subTaskResult.exception() != null) {
                            exceptionDuringTask[0] = subTaskResult.exception();
                        }
                    }
                    next.set(finalI, subTaskResult);
                    waiter.count();
                }
            });
        }
        waiter.then(new Job(){

            @Override
            public void run() {
                TaskResult endResult = next;
                if (subTasksSize == 1) {
                    endResult = (TaskResult)next.get(0);
                }
                if (exceptionDuringTask[0] != null) {
                    ctx.endTask(endResult, exceptionDuringTask[0]);
                } else {
                    ctx.continueWith(endResult);
                }
            }
        });
    }

    @Override
    public Task[] children() {
        return this._subTasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.PIPE_PAR);
        builder.writeChar('(');
        for (int i = 0; i < this._subTasks.length; ++i) {
            if (i != 0) {
                builder.writeChar(',');
            }
            CoreTask castedAction = (CoreTask)this._subTasks[i];
            int castedActionHash = castedAction.hashCode();
            if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
                builder.writeChar('{');
                castedAction.serialize(builder, dagIDS);
                builder.writeChar('}');
                continue;
            }
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        builder.writeChar(')');
    }
}

