/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Callback;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.struct.Buffer;
import java.util.Map;

class CF_PipeTo
extends CF_Action {
    private final Task _subTask;
    private final String[] _targets;

    CF_PipeTo(Task p_subTask, String ... p_targets) {
        if (p_subTask == null) {
            throw new RuntimeException("subTask should not be null");
        }
        this._subTask = p_subTask;
        this._targets = p_targets;
    }

    @Override
    public void eval(final TaskContext ctx) {
        final TaskResult previous = ctx.result();
        this._subTask.executeFrom(ctx, previous, (byte)0, new Callback<TaskResult>(){

            @Override
            public void on(TaskResult result) {
                Exception exceptionDuringTask = null;
                if (result != null) {
                    if (result.output() != null) {
                        ctx.append(result.output());
                    }
                    if (result.exception() != null) {
                        exceptionDuringTask = result.exception();
                    }
                    if (CF_PipeTo.this._targets != null && CF_PipeTo.this._targets.length > 0) {
                        for (int i = 0; i < CF_PipeTo.this._targets.length; ++i) {
                            ctx.setVariable(CF_PipeTo.this._targets[i], result);
                        }
                    } else {
                        result.free();
                    }
                }
                if (exceptionDuringTask != null) {
                    ctx.endTask(previous, exceptionDuringTask);
                } else {
                    ctx.continueWith(previous);
                }
            }
        });
    }

    @Override
    public Task[] children() {
        Task[] children_tasks = new Task[]{this._subTask};
        return children_tasks;
    }

    @Override
    public void cf_serialize(Buffer builder, Map<Integer, Integer> dagIDS) {
        builder.writeString(CoreActionNames.PIPE_TO);
        builder.writeChar('(');
        CoreTask castedAction = (CoreTask)this._subTask;
        int castedActionHash = castedAction.hashCode();
        if (dagIDS == null || !dagIDS.containsKey(castedActionHash)) {
            builder.writeChar('{');
            castedAction.serialize(builder, dagIDS);
            builder.writeChar('}');
        } else {
            builder.writeString("" + dagIDS.get(castedActionHash));
        }
        if (this._targets != null && this._targets.length > 0) {
            builder.writeChar(',');
            TaskHelper.serializeStringParams(this._targets, builder);
        }
        builder.writeChar(')');
    }
}

