/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.TaskFunctionSelect;
import greycat.TaskFunctionSelectObject;
import greycat.Type;
import greycat.internal.task.ActionAddRemoveToGlobalIndex;
import greycat.internal.task.ActionAddRemoveVarToRelation;
import greycat.internal.task.ActionAddToVar;
import greycat.internal.task.ActionAttributes;
import greycat.internal.task.ActionClearResult;
import greycat.internal.task.ActionCreateNode;
import greycat.internal.task.ActionDeclareVar;
import greycat.internal.task.ActionDefineAsVar;
import greycat.internal.task.ActionExecuteExpression;
import greycat.internal.task.ActionFlat;
import greycat.internal.task.ActionFlipVar;
import greycat.internal.task.ActionGlobalIndex;
import greycat.internal.task.ActionIndexNames;
import greycat.internal.task.ActionInject;
import greycat.internal.task.ActionLog;
import greycat.internal.task.ActionLookup;
import greycat.internal.task.ActionLookupAll;
import greycat.internal.task.ActionNamed;
import greycat.internal.task.ActionPrint;
import greycat.internal.task.ActionReadGlobalIndex;
import greycat.internal.task.ActionReadVar;
import greycat.internal.task.ActionRemove;
import greycat.internal.task.ActionSave;
import greycat.internal.task.ActionScript;
import greycat.internal.task.ActionSelect;
import greycat.internal.task.ActionSelectObject;
import greycat.internal.task.ActionSetAsVar;
import greycat.internal.task.ActionSetAttribute;
import greycat.internal.task.ActionTimeSensitivity;
import greycat.internal.task.ActionTimepoints;
import greycat.internal.task.ActionTravelInTime;
import greycat.internal.task.ActionTravelInWorld;
import greycat.internal.task.ActionTraverseOrAttribute;
import greycat.internal.task.ActionWith;
import greycat.internal.task.ActionWithout;

public class CoreActions {
    public static Action flat() {
        return new ActionFlat();
    }

    public static Action travelInWorld(String world) {
        return new ActionTravelInWorld(world);
    }

    public static Action travelInTime(String time) {
        return new ActionTravelInTime(time);
    }

    public static Action inject(Object input) {
        return new ActionInject(input);
    }

    public static Action defineAsGlobalVar(String name) {
        return new ActionDefineAsVar(name, true);
    }

    public static Action defineAsVar(String name) {
        return new ActionDefineAsVar(name, false);
    }

    public static Action declareGlobalVar(String name) {
        return new ActionDeclareVar(true, name);
    }

    public static Action declareVar(String name) {
        return new ActionDeclareVar(false, name);
    }

    public static Action readVar(String name) {
        return new ActionReadVar(name);
    }

    public static Action flipVar(String name) {
        return new ActionFlipVar(name);
    }

    public static Action setAsVar(String name) {
        return new ActionSetAsVar(name);
    }

    public static Action addToVar(String name) {
        return new ActionAddToVar(name);
    }

    public static Action setAttribute(String name, byte type, String value) {
        return new ActionSetAttribute(name, Type.typeName(type), value, false);
    }

    public static Action timeSensitivity(String delta, String offset) {
        return new ActionTimeSensitivity(delta, offset);
    }

    public static Action forceAttribute(String name, byte type, String value) {
        return new ActionSetAttribute(name, Type.typeName(type), value, true);
    }

    public static Action remove(String name) {
        return new ActionRemove(name);
    }

    public static Action attributes() {
        return new ActionAttributes(null);
    }

    public static Action attributesWithTypes(byte filterType) {
        return new ActionAttributes(Type.typeName(filterType));
    }

    public static Action addVarToRelation(String relName, String varName, String ... attributes) {
        return new ActionAddRemoveVarToRelation(true, relName, varName, attributes);
    }

    public static Action removeVarFromRelation(String relName, String varFrom, String ... attributes) {
        return new ActionAddRemoveVarToRelation(false, relName, varFrom, attributes);
    }

    public static Action traverse(String name, String ... params) {
        return new ActionTraverseOrAttribute(false, false, name, params);
    }

    public static Action attribute(String name, String ... params) {
        return new ActionTraverseOrAttribute(true, false, name, params);
    }

    public static Action readGlobalIndex(String indexName, String ... query) {
        return new ActionReadGlobalIndex(indexName, query);
    }

    public static Action globalIndex(String indexName) {
        return new ActionGlobalIndex(indexName);
    }

    public static Action addToGlobalIndex(String name, String ... attributes) {
        return new ActionAddRemoveToGlobalIndex(false, false, name, attributes);
    }

    public static Action addToGlobalTimedIndex(String name, String ... attributes) {
        return new ActionAddRemoveToGlobalIndex(false, true, name, attributes);
    }

    public static Action removeFromGlobalIndex(String name, String ... attributes) {
        return new ActionAddRemoveToGlobalIndex(true, false, name, attributes);
    }

    public static Action removeFromGlobalTimedIndex(String name, String ... attributes) {
        return new ActionAddRemoveToGlobalIndex(true, true, name, attributes);
    }

    public static Action indexNames() {
        return new ActionIndexNames();
    }

    public static Action selectWith(String name, String pattern) {
        return new ActionWith(name, pattern);
    }

    public static Action selectWithout(String name, String pattern) {
        return new ActionWithout(name, pattern);
    }

    public static Action select(TaskFunctionSelect filterFunction) {
        return new ActionSelect(null, filterFunction);
    }

    public static Action selectObject(TaskFunctionSelectObject filterFunction) {
        return new ActionSelectObject(filterFunction);
    }

    public static Action selectScript(String script) {
        return new ActionSelect(script, null);
    }

    public static Action log(String value) {
        return new ActionLog(value);
    }

    public static Action print(String name) {
        return new ActionPrint(name, false);
    }

    public static Action println(String name) {
        return new ActionPrint(name, true);
    }

    public static Action executeExpression(String expression) {
        return new ActionExecuteExpression(expression);
    }

    public static Action action(String name, String ... params) {
        return new ActionNamed(name, params);
    }

    public static Action createNode() {
        return new ActionCreateNode(null);
    }

    public static Action createTypedNode(String type) {
        return new ActionCreateNode(type);
    }

    public static Action save() {
        return new ActionSave();
    }

    public static Action script(String script) {
        return new ActionScript(script, false);
    }

    public static Action asyncScript(String script) {
        return new ActionScript(script, true);
    }

    public static Action lookup(String nodeId) {
        return new ActionLookup(nodeId);
    }

    public static Action lookupAll(String nodeIds) {
        return new ActionLookupAll(nodeIds);
    }

    public static Action timepoints(String from, String to) {
        return new ActionTimepoints(from, to);
    }

    public static Action clearResult() {
        return new ActionClearResult();
    }
}

