/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.ActionFunction;
import greycat.Callback;
import greycat.ConditionalFunction;
import greycat.DeferCounterSync;
import greycat.Graph;
import greycat.Task;
import greycat.TaskContext;
import greycat.TaskFunctionSelect;
import greycat.TaskFunctionSelectObject;
import greycat.TaskHook;
import greycat.TaskResult;
import greycat.Tasks;
import greycat.base.BaseTaskResult;
import greycat.internal.heap.HeapBuffer;
import greycat.internal.task.ActionAddToVar;
import greycat.internal.task.ActionAttributes;
import greycat.internal.task.ActionCreateNode;
import greycat.internal.task.ActionDeclareVar;
import greycat.internal.task.ActionDefineAsVar;
import greycat.internal.task.ActionExecuteExpression;
import greycat.internal.task.ActionFlat;
import greycat.internal.task.ActionGlobalIndex;
import greycat.internal.task.ActionLog;
import greycat.internal.task.ActionNamed;
import greycat.internal.task.ActionPrint;
import greycat.internal.task.ActionQueryBoundedRadius;
import greycat.internal.task.ActionReadGlobalIndex;
import greycat.internal.task.ActionReadVar;
import greycat.internal.task.ActionSave;
import greycat.internal.task.ActionScript;
import greycat.internal.task.ActionSelect;
import greycat.internal.task.ActionSetAsVar;
import greycat.internal.task.ActionSetAttribute;
import greycat.internal.task.ActionTimeSensitivity;
import greycat.internal.task.ActionTravelInTime;
import greycat.internal.task.ActionTravelInWorld;
import greycat.internal.task.ActionTraverseOrAttribute;
import greycat.internal.task.ActionWith;
import greycat.internal.task.ActionWithout;
import greycat.internal.task.CF_Action;
import greycat.internal.task.CF_Atomic;
import greycat.internal.task.CF_DoWhile;
import greycat.internal.task.CF_ForEach;
import greycat.internal.task.CF_ForEachPar;
import greycat.internal.task.CF_IfThen;
import greycat.internal.task.CF_IfThenElse;
import greycat.internal.task.CF_Loop;
import greycat.internal.task.CF_LoopPar;
import greycat.internal.task.CF_Map;
import greycat.internal.task.CF_MapPar;
import greycat.internal.task.CF_Pipe;
import greycat.internal.task.CF_PipePar;
import greycat.internal.task.CF_PipeTo;
import greycat.internal.task.CF_ThenDo;
import greycat.internal.task.CF_WhileDo;
import greycat.internal.task.CoreActionNames;
import greycat.internal.task.CoreActions;
import greycat.internal.task.CoreTaskContext;
import greycat.internal.task.CoreTaskReader;
import greycat.internal.task.TaskHelper;
import greycat.plugin.ActionDeclaration;
import greycat.plugin.ActionFactory;
import greycat.plugin.ActionRegistry;
import greycat.plugin.Job;
import greycat.struct.Buffer;
import greycat.utility.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public class CoreTask
implements Task {
    private int insertCapacity = 8;
    public Action[] actions = new Action[this.insertCapacity];
    public int insertCursor = 0;
    TaskHook[] _hooks = null;

    @Override
    public final Task addHook(TaskHook p_hook) {
        if (this._hooks == null) {
            this._hooks = new TaskHook[1];
            this._hooks[0] = p_hook;
        } else {
            TaskHook[] new_hooks = new TaskHook[this._hooks.length + 1];
            System.arraycopy(this._hooks, 0, new_hooks, 0, this._hooks.length);
            new_hooks[this._hooks.length] = p_hook;
            this._hooks = new_hooks;
        }
        return this;
    }

    @Override
    public final Task then(Action nextAction) {
        if (this.insertCapacity == this.insertCursor) {
            Action[] new_actions = new Action[this.insertCapacity * 2];
            System.arraycopy(this.actions, 0, new_actions, 0, this.insertCapacity);
            this.actions = new_actions;
            this.insertCapacity *= 2;
        }
        this.actions[this.insertCursor] = nextAction;
        ++this.insertCursor;
        return this;
    }

    @Override
    public final Task thenDo(ActionFunction nextActionFunction) {
        return this.then(new CF_ThenDo(nextActionFunction));
    }

    @Override
    public final Task doWhile(Task task, ConditionalFunction cond) {
        return this.then(new CF_DoWhile(task, cond, null));
    }

    @Override
    public final Task doWhileScript(Task task, String condScript) {
        return this.then(new CF_DoWhile(task, CoreTask.condFromScript(condScript), condScript));
    }

    @Override
    public final Task loop(String from, String to, Task subTask) {
        return this.then(new CF_Loop(from, to, subTask));
    }

    @Override
    public final Task loopPar(String from, String to, Task subTask) {
        return this.then(new CF_LoopPar(from, to, subTask));
    }

    @Override
    public final Task forEach(Task subTask) {
        return this.then(new CF_ForEach(subTask));
    }

    @Override
    public final Task forEachPar(Task subTask) {
        return this.then(new CF_ForEachPar(subTask));
    }

    @Override
    public final Task map(Task subTask) {
        return this.then(new CF_Map(subTask));
    }

    @Override
    public final Task mapPar(Task subTask) {
        return this.then(new CF_MapPar(subTask));
    }

    @Override
    public final Task ifThen(ConditionalFunction cond, Task then) {
        return this.then(new CF_IfThen(cond, then, null));
    }

    @Override
    public final Task ifThenScript(String condScript, Task then) {
        return this.then(new CF_IfThen(CoreTask.condFromScript(condScript), then, condScript));
    }

    @Override
    public final Task ifThenElse(ConditionalFunction cond, Task thenSub, Task elseSub) {
        return this.then(new CF_IfThenElse(cond, thenSub, elseSub, null));
    }

    @Override
    public final Task ifThenElseScript(String condScript, Task thenSub, Task elseSub) {
        return this.then(new CF_IfThenElse(CoreTask.condFromScript(condScript), thenSub, elseSub, condScript));
    }

    @Override
    public final Task whileDo(ConditionalFunction cond, Task task) {
        return this.then(new CF_WhileDo(cond, task, null));
    }

    @Override
    public final Task whileDoScript(String condScript, Task task) {
        return this.then(new CF_WhileDo(CoreTask.condFromScript(condScript), task, condScript));
    }

    @Override
    public final Task pipe(Task ... subTasks) {
        return this.then(new CF_Pipe(subTasks));
    }

    @Override
    public final Task pipePar(Task ... subTasks) {
        return this.then(new CF_PipePar(subTasks));
    }

    @Override
    public final Task pipeTo(Task subTask, String ... vars) {
        return this.then(new CF_PipeTo(subTask, vars));
    }

    @Override
    public final Task atomic(Task protectedTask, String ... variablesToLock) {
        return this.then(new CF_Atomic(protectedTask, variablesToLock));
    }

    @Override
    public final void execute(Graph graph, Callback<TaskResult> callback) {
        this.executeWith(graph, null, callback);
    }

    @Override
    public final TaskResult executeSync(Graph graph) {
        DeferCounterSync waiter = graph.newSyncCounter(1);
        this.executeWith(graph, null, waiter.wrap());
        return (TaskResult)waiter.waitResult();
    }

    @Override
    public final void executeWith(Graph graph, Object initial, Callback<TaskResult> callback) {
        if (this.insertCursor > 0) {
            TaskResult initalRes = initial instanceof BaseTaskResult ? ((TaskResult)initial).clone() : new BaseTaskResult(initial, true);
            final CoreTaskContext context = new CoreTaskContext(this, this._hooks, null, initalRes, graph, callback);
            graph.scheduler().dispatch((byte)0, new Job(){

                @Override
                public void run() {
                    context.execute();
                }
            });
        } else if (callback != null) {
            callback.on(Tasks.emptyResult());
        }
    }

    @Override
    public final TaskContext prepare(Graph graph, Object initial, Callback<TaskResult> callback) {
        TaskResult initalRes = initial instanceof BaseTaskResult ? ((TaskResult)initial).clone() : new BaseTaskResult(initial, true);
        return new CoreTaskContext(this, this._hooks, null, initalRes, graph, callback);
    }

    @Override
    public final void executeUsing(final TaskContext preparedContext) {
        if (this.insertCursor > 0) {
            preparedContext.graph().scheduler().dispatch((byte)0, new Job(){

                @Override
                public void run() {
                    ((CoreTaskContext)preparedContext).execute();
                }
            });
        } else {
            CoreTaskContext casted = (CoreTaskContext)preparedContext;
            if (casted._callback != null) {
                casted._callback.on(Tasks.emptyResult());
            }
        }
    }

    @Override
    public final void executeFrom(TaskContext parentContext, TaskResult initial, byte affinity, Callback<TaskResult> callback) {
        if (this.insertCursor > 0) {
            TaskHook[] aggregatedHooks = null;
            if (parentContext != null) {
                aggregatedHooks = ((CoreTaskContext)parentContext)._hooks;
            }
            if (this._hooks != null) {
                if (aggregatedHooks == null) {
                    aggregatedHooks = this._hooks;
                } else {
                    TaskHook[] temp_hooks = new TaskHook[aggregatedHooks.length + this._hooks.length];
                    System.arraycopy(aggregatedHooks, 0, temp_hooks, 0, aggregatedHooks.length);
                    System.arraycopy(this._hooks, 0, temp_hooks, aggregatedHooks.length, this._hooks.length);
                    aggregatedHooks = temp_hooks;
                }
            }
            final CoreTaskContext context = new CoreTaskContext(this, aggregatedHooks, parentContext, initial.clone(), parentContext.graph(), callback);
            parentContext.graph().scheduler().dispatch(affinity, new Job(){

                @Override
                public void run() {
                    context.execute();
                }
            });
        } else if (callback != null) {
            callback.on(Tasks.emptyResult());
        }
    }

    @Override
    public final void executeFromUsing(TaskContext parentContext, TaskResult initial, byte affinity, Callback<TaskContext> contextInitializer, Callback<TaskResult> callback) {
        if (this.insertCursor > 0) {
            TaskHook[] aggregatedHooks = null;
            if (parentContext != null) {
                aggregatedHooks = ((CoreTaskContext)parentContext)._hooks;
            }
            if (this._hooks != null) {
                if (aggregatedHooks == null) {
                    aggregatedHooks = this._hooks;
                } else {
                    TaskHook[] temp_hooks = new TaskHook[aggregatedHooks.length + this._hooks.length];
                    System.arraycopy(aggregatedHooks, 0, temp_hooks, 0, aggregatedHooks.length);
                    System.arraycopy(this._hooks, 0, temp_hooks, aggregatedHooks.length, this._hooks.length);
                    aggregatedHooks = temp_hooks;
                }
            }
            final CoreTaskContext context = new CoreTaskContext(this, aggregatedHooks, parentContext, initial.clone(), parentContext.graph(), callback);
            if (contextInitializer != null) {
                contextInitializer.on(context);
            }
            parentContext.graph().scheduler().dispatch(affinity, new Job(){

                @Override
                public void run() {
                    context.execute();
                }
            });
        } else if (callback != null) {
            callback.on(Tasks.emptyResult());
        }
    }

    @Override
    public final Task loadFromBuffer(Buffer buffer, Graph graph) {
        return this.parse(Base64.decodeToStringWithBounds(buffer, 0L, buffer.length()), graph);
    }

    @Override
    public final Task saveToBuffer(Buffer buffer) {
        String saved = this.toString();
        Base64.encodeStringToBuffer(saved, buffer);
        return this;
    }

    @Override
    public final Task parse(String flat, Graph graph) {
        if (flat == null) {
            throw new RuntimeException("flat should not be null");
        }
        HashMap<Integer, Task> contextTasks = new HashMap<Integer, Task>();
        this.sub_parse(new CoreTaskReader(flat, 0), graph, contextTasks);
        return this;
    }

    private void sub_parse(CoreTaskReader reader, Graph graph, Map<Integer, Task> contextTasks) {
        String getName;
        ActionRegistry registry = graph.actionRegistry();
        int flatSize = reader.available();
        int previous = 0;
        String actionName = null;
        boolean isClosed = false;
        boolean isEscaped = false;
        int paramsCapacity = 0;
        String[] params = null;
        int paramsIndex = 0;
        String previousTaskId = null;
        boolean subTaskMode = false;
        block10: for (int cursor = 0; cursor < flatSize; ++cursor) {
            char current = reader.charAt(cursor);
            switch (current) {
                case '\"': 
                case '\'': {
                    isEscaped = true;
                    ++cursor;
                    boolean previousBackS = false;
                    while (cursor < flatSize) {
                        char loopChar = reader.charAt(cursor);
                        if (loopChar == '\\') {
                            previousBackS = true;
                        } else {
                            if (current == loopChar && !previousBackS) continue block10;
                            previousBackS = false;
                        }
                        ++cursor;
                    }
                    continue block10;
                }
                case '.': {
                    if (!isClosed) {
                        String getName2 = reader.extract(previous, cursor).trim();
                        this.then(new ActionTraverseOrAttribute(false, true, getName2, new String[0]));
                    }
                    actionName = null;
                    isEscaped = false;
                    previous = cursor + 1;
                    paramsCapacity = 0;
                    params = null;
                    paramsIndex = 0;
                    isClosed = false;
                    continue block10;
                }
                case '#': {
                    if (!isClosed) {
                        String getName3 = reader.extract(previous, cursor).trim();
                        this.then(new ActionTraverseOrAttribute(false, true, getName3, new String[0]));
                    }
                    subTaskMode = true;
                    actionName = null;
                    isEscaped = false;
                    previous = cursor + 1;
                    paramsCapacity = 0;
                    params = null;
                    paramsIndex = 0;
                    continue block10;
                }
                case '(': {
                    actionName = reader.extract(previous, cursor).trim();
                    previous = cursor + 1;
                    continue block10;
                }
                case ')': {
                    String lastParamExtracted;
                    if (previousTaskId != null) {
                        lastParamExtracted = previousTaskId;
                        previousTaskId = null;
                    } else {
                        lastParamExtracted = isEscaped ? reader.extract(previous + 1, cursor - 1) : reader.extract(previous, cursor);
                    }
                    if (lastParamExtracted.length() > 0) {
                        if (paramsIndex + 1 != paramsCapacity) {
                            String[] newParams = new String[paramsIndex + 1];
                            if (params != null) {
                                System.arraycopy(params, 0, newParams, 0, paramsIndex);
                            }
                            params = newParams;
                            paramsCapacity = paramsIndex + 1;
                        }
                        params[paramsIndex] = lastParamExtracted;
                        ++paramsIndex;
                    } else if (paramsIndex < paramsCapacity) {
                        String[] shrinked = new String[paramsIndex];
                        System.arraycopy(params, 0, shrinked, 0, paramsIndex);
                        params = shrinked;
                    }
                    if (graph == null) {
                        this.then(new ActionNamed(actionName, params));
                    } else {
                        this.then(CoreTask.loadAction(registry, actionName, params, contextTasks));
                    }
                    actionName = null;
                    previous = cursor + 1;
                    isClosed = true;
                    continue block10;
                }
                case ',': {
                    String paramExtracted;
                    if (previousTaskId != null) {
                        paramExtracted = previousTaskId;
                        previousTaskId = null;
                    } else {
                        paramExtracted = isEscaped ? reader.extract(previous + 1, cursor - 1) : reader.extract(previous, cursor);
                    }
                    if (paramExtracted.length() > 0) {
                        if (paramsIndex >= paramsCapacity) {
                            int newParamsCapacity = paramsCapacity * 2;
                            if (newParamsCapacity == 0) {
                                newParamsCapacity = 8;
                            }
                            String[] newParams = new String[newParamsCapacity];
                            if (params != null) {
                                System.arraycopy(params, 0, newParams, 0, paramsCapacity);
                            }
                            params = newParams;
                            paramsCapacity = newParamsCapacity;
                        }
                        params[paramsIndex] = paramExtracted;
                        ++paramsIndex;
                    }
                    previous = cursor + 1;
                    isEscaped = false;
                    continue block10;
                }
                case '{': {
                    CoreTask subTask;
                    if (cursor <= 0 || cursor + 1 >= flatSize || reader.charAt(cursor + 1) == '{' || reader.charAt(cursor - 1) == '{') continue block10;
                    CoreTaskReader subReader = reader.slice(cursor + 1);
                    if (subTaskMode) {
                        String subTaskName = reader.extract(previous, cursor).trim();
                        Integer subTaskID = TaskHelper.parseInt(subTaskName);
                        subTask = (CoreTask)contextTasks.get(subTaskID);
                    } else {
                        subTask = new CoreTask();
                    }
                    subTask.sub_parse(subReader, graph, contextTasks);
                    cursor = cursor + subReader.end() + 1;
                    previous = cursor + 1;
                    Integer hash = subTask.hashCode();
                    contextTasks.put(hash, subTask);
                    previousTaskId = hash + "";
                    continue block10;
                }
                case '}': {
                    if (cursor <= 0 || cursor + 1 >= flatSize || reader.charAt(cursor + 1) == '}' || reader.charAt(cursor - 1) == '}') continue block10;
                    reader.markend(cursor);
                    return;
                }
            }
        }
        if (!isClosed && (getName = reader.extract(previous, flatSize)).length() > 0) {
            if (actionName != null) {
                if (graph == null) {
                    this.then(new ActionNamed(actionName, params));
                } else {
                    String[] singleParam = new String[]{getName};
                    this.then(CoreTask.loadAction(registry, actionName, singleParam, contextTasks));
                }
            } else {
                this.then(new ActionTraverseOrAttribute(false, true, getName.trim(), new String[0]));
            }
        }
    }

    static Action loadAction(ActionRegistry registry, String actionName, String[] params, Map<Integer, Task> contextTasks) {
        ActionDeclaration declaration = registry.declaration(actionName);
        if (declaration == null || declaration.factory() == null) {
            String[] varargs = params;
            return new ActionNamed(actionName, varargs);
        }
        ActionFactory factory = declaration.factory();
        byte[] declaredParams = declaration.params();
        if (declaredParams != null && params != null) {
            int i;
            int resultSize = declaredParams.length;
            Object[] parsedParams = new Object[resultSize];
            int varargs_index = 0;
            block9: for (i = 0; i < params.length; ++i) {
                byte correspondingType = i < resultSize ? declaredParams[i] : declaredParams[resultSize - 1];
                switch (correspondingType) {
                    case 2: {
                        parsedParams[i] = params[i];
                        continue block9;
                    }
                    case 3: {
                        parsedParams[i] = Long.parseLong(params[i]);
                        continue block9;
                    }
                    case 5: {
                        parsedParams[i] = Double.parseDouble(params[i]);
                        continue block9;
                    }
                    case 20: {
                        parsedParams[i] = CoreTask.getOrCreate(contextTasks, params[i]);
                        continue block9;
                    }
                    case 9: {
                        Object[] parsedSubParam;
                        if (varargs_index == 0) {
                            parsedSubParam = new String[resultSize - i];
                            parsedSubParam[varargs_index] = params[i];
                            varargs_index = 1;
                            parsedParams[i] = parsedSubParam;
                            continue block9;
                        }
                        ((String[])parsedParams[resultSize - 1])[varargs_index] = params[i];
                        ++varargs_index;
                        continue block9;
                    }
                    case 6: {
                        Object[] parsedSubParam;
                        if (varargs_index == 0) {
                            parsedSubParam = new double[resultSize - i];
                            parsedSubParam[varargs_index] = (String)Double.parseDouble(params[i]);
                            varargs_index = 1;
                            parsedParams[i] = parsedSubParam;
                            continue block9;
                        }
                        ((double[])parsedParams[resultSize - 1])[varargs_index] = Double.parseDouble(params[i]);
                        ++varargs_index;
                        continue block9;
                    }
                    case 21: {
                        if (varargs_index == 0) {
                            Task[] parsedSubParamTask = new Task[resultSize - i];
                            parsedSubParamTask[varargs_index] = CoreTask.getOrCreate(contextTasks, params[i]);
                            varargs_index = 1;
                            parsedParams[i] = parsedSubParamTask;
                            continue block9;
                        }
                        ((Task[])parsedParams[resultSize - 1])[varargs_index] = CoreTask.getOrCreate(contextTasks, params[i]);
                        ++varargs_index;
                    }
                }
            }
            if (resultSize > params.length) {
                for (i = params.length; i < resultSize; ++i) {
                    parsedParams[i] = null;
                }
            }
            return factory.create(parsedParams);
        }
        return factory.create(new Object[0]);
    }

    private static ConditionalFunction condFromScript(final String script) {
        return new ConditionalFunction(){

            @Override
            public boolean eval(TaskContext ctx) {
                return CoreTask.executeScript(script, ctx);
            }
        };
    }

    private static boolean executeScript(String script, TaskContext context) {
        SimpleScriptContext scriptCtx = new SimpleScriptContext();
        scriptCtx.setAttribute("ctx", context, 100);
        try {
            return (Boolean)TaskHelper.SCRIPT_ENGINE.eval(script, (ScriptContext)scriptCtx);
        }
        catch (ClassCastException | ScriptException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void fillDefault(ActionRegistry registry) {
        registry.declaration(CoreActionNames.TRAVEL_IN_WORLD).setParams(2).setDescription("Sets the task context to a particular world. Every nodes in current result will be switch ot new world.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionTravelInWorld((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.TRAVEL_IN_TIME).setParams(2).setDescription("Switches the time of the task context, i.e. travels the task context in time. Every nodes in current result will be switch ot new time.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionTravelInTime((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.DEFINE_AS_GLOBAL_VAR).setParams(2).setDescription("Stores the task result as a global variable in the task context and starts a new scope (for sub tasks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionDefineAsVar((String)params[0], true);
            }
        });
        registry.declaration(CoreActionNames.DEFINE_AS_VAR).setParams(2).setDescription("Stores the task result as a local variable in the task context and starts a new scope (for sub tasks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionDefineAsVar((String)params[0], false);
            }
        });
        registry.declaration(CoreActionNames.DECLARE_GLOBAL_VAR).setParams(2).setDescription("Stores the task result as a global variable in the task context and starts a new scope (for sub tasks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionDeclareVar(true, (String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.DECLARE_VAR).setParams(2).setDescription("Stores the task result as a local variable in the task context and starts a new scope (for sub tasks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionDeclareVar(false, (String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.READ_VAR).setParams(2).setDescription("Retrieves a stored variable. To reach a particular index, a default array notation can be used. Therefore, A[B] will be interpreted as: extract value stored at index B from the variable A.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionReadVar((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.SET_AS_VAR).setParams(2).setDescription("Stores the current task result into a named variable without starting a new scope.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionSetAsVar((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.ADD_TO_VAR).setParams(2).setDescription("Adds the current task result to the named variable.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionAddToVar((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.TRAVERSE).setParams(2, 9).setDescription("Retrieves any nodes contained in a relations of the nodes present in the current result.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                String[] varrags = (String[])params[1];
                if (varrags != null) {
                    return new ActionTraverseOrAttribute(false, false, (String)params[0], varrags);
                }
                return new ActionTraverseOrAttribute(false, false, (String)params[0], new String[0]);
            }
        });
        registry.declaration(CoreActionNames.ATTRIBUTE).setParams(2).setDescription("Retrieves any attribute(s) contained in the nodes present in the current result.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionTraverseOrAttribute(false, false, (String)params[0], new String[0]);
            }
        });
        registry.declaration(CoreActionNames.WITH).setParams(2, 2).setDescription("Filters the previous result to keep nodes, which named attribute has a specific value.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionWith((String)params[0], (String)params[1]);
            }
        });
        registry.declaration(CoreActionNames.WITHOUT).setParams(2, 2).setDescription("Filters the previous result to keep nodes, which named attribute does not have a given value.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionWithout((String)params[0], (String)params[1]);
            }
        });
        registry.declaration(CoreActionNames.SCRIPT).setParams(2).setDescription("Execute a JS script; Current context is automatically injected as ctx variables. Other variables are directly reachable as JS vars. Execution is synchronous").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionScript((String)params[0], false);
            }
        });
        registry.declaration(CoreActionNames.ASYNC_SCRIPT).setParams(2).setDescription("Execute a JS script; Current context is automatically injected as ctx variables. Other variables are directly reachable as JS vars. Execution is asynchronous and script must contains a ctx.continueTask(); or ctx.continueWith(newResult).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionScript((String)params[0], true);
            }
        });
        registry.declaration(CoreActionNames.CREATE_NODE).setParams(new byte[0]).setDescription("Creates a new node in the [world,time] of the current context.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionCreateNode(null);
            }
        });
        registry.declaration(CoreActionNames.CREATE_TYPED_NODE).setParams(2).setDescription("Creates a new typed node in the [world,time] of the current context.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionCreateNode((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.PRINT).setParams(2).setDescription("Prints the action in a human readable format (without line breaks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionPrint((String)params[0], false);
            }
        });
        registry.declaration(CoreActionNames.LOG).setParams(2).setDescription("Prints the action in a human readable format (without line breaks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionLog((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.PRINTLN).setParams(2).setDescription("Prints the action in a human readable format (with line breaks).").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionPrint((String)params[0], true);
            }
        });
        registry.declaration(CoreActionNames.ATTRIBUTES).setParams(new byte[0]).setDescription("Retrieves all attribute names of nodes present in the previous task result.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionAttributes(null);
            }
        });
        registry.declaration(CoreActionNames.ATTRIBUTES).setParams(new byte[0]).setDescription("Retrieves all attribute names of nodes present in the previous task result.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionAttributes(null);
            }
        });
        registry.declaration(CoreActionNames.ATTRIBUTES_WITH_TYPE).setParams(2).setDescription("Gets and filters all attribute names of nodes present in the previous result.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionAttributes((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.FLAT).setParams(new byte[0]).setDescription("Flat a TaskResult containing TaskResult to a flat TaskResult.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionFlat();
            }
        });
        registry.declaration(CoreActionNames.SAVE).setParams(new byte[0]).setDescription("Save current cache into persistence storage").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionSave();
            }
        });
        registry.declaration(CoreActionNames.EXECUTE_EXPRESSION).setParams(2).setDescription("Executes an expression on all nodes given from the previous step.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionExecuteExpression((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.READ_GLOBAL_INDEX).setParams(2, 9).setDescription("Retrieves indexed nodes matching the query.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                String[] varargs = (String[])params[1];
                if (varargs != null) {
                    return new ActionReadGlobalIndex((String)params[0], varargs);
                }
                return new ActionReadGlobalIndex((String)params[0], new String[0]);
            }
        });
        registry.declaration(CoreActionNames.GLOBAL_INDEX).setParams(2).setDescription("Retrieve global index node").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionGlobalIndex((String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.SELECT).setParams(2).setDescription("Use a JS script to filter nodes. The task context is inject in the variable 'context'. The current node is inject in the variable 'node'.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionSelect((String)params[0], null);
            }
        });
        registry.declaration(CoreActionNames.TIME_SENSITIVITY).setParams(2, 2).setDescription("Adjust the time sensitivity of nodes present in current result.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionTimeSensitivity((String)params[0], (String)params[1]);
            }
        });
        registry.declaration(CoreActionNames.SET_ATTRIBUTE).setParams(2, 2, 2).setDescription("Sets the value of an attribute for all nodes present in the current result. If value is similar to the previously stored one, nodes will remain unmodified.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionSetAttribute((String)params[0], (String)params[1], (String)params[2], true);
            }
        });
        registry.declaration(CoreActionNames.FORCE_ATTRIBUTE).setParams(2, 2, 2).setDescription("Forces the value of an attribute for all nodes present in the current result. If value is similar to the previously stored one, nodes will still be modified and their timeline will be affected.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionSetAttribute((String)params[0], (String)params[1], (String)params[2], true);
            }
        });
        registry.declaration(CoreActionNames.LOOP).setParams(2, 2, 20).setDescription("Executes a task in a range.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_Loop((String)params[0], (String)params[1], (Task)params[2]);
            }
        });
        registry.declaration(CoreActionNames.LOOP_PAR).setParams(2, 2, 20).setDescription("Parallel version of loop(String, String, Task). Executes a task in a range. Steps can be executed in parallel. Creates as many threads as elements in the collection.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_LoopPar((String)params[0], (String)params[1], (Task)params[2]);
            }
        });
        registry.declaration(CoreActionNames.FOR_EACH).setParams(20).setDescription("Iterates through a collection and calls the sub task for each element.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_ForEach((Task)params[0]);
            }
        });
        registry.declaration(CoreActionNames.FOR_EACH_PAR).setParams(20).setDescription("Parallel version of forEach(Task). All sub tasks can be called in parallel. Creates as many threads as elements in the collection.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_ForEachPar((Task)params[0]);
            }
        });
        registry.declaration(CoreActionNames.MAP).setParams(20).setDescription("Iterates through a collection and calls the sub task for each element in parallel and then aggregates all results in an array of array manner.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_Map((Task)params[0]);
            }
        });
        registry.declaration(CoreActionNames.MAP_PAR).setParams(20).setDescription("Parallel version of map(Task). Iterates through a collection and calls the sub task for each element in parallel and then aggregates all results in an array of array manner.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_MapPar((Task)params[0]);
            }
        });
        registry.declaration(CoreActionNames.PIPE).setParams(21).setDescription("Executes and waits for a number of given sub tasks. The result of these sub tasks is immediately enqueued and available in the next sub task in a array of array manner.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                Task[] varargs = (Task[])params[0];
                return new CF_Pipe(varargs);
            }
        });
        registry.declaration(CoreActionNames.PIPE_PAR).setParams(21).setDescription("Parallel version of pipe(Tasks...). Executes and waits a number of given sub tasks. The result of these sub tasks is immediately enqueued and available in the next sub task in a array of array manner.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                Task[] varargs = (Task[])params[0];
                return new CF_PipePar(varargs);
            }
        });
        registry.declaration(CoreActionNames.DO_WHILE).setParams(2, 20).setDescription("Executes a give task until a given condition evaluates to true.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_DoWhile((Task)params[1], CoreTask.condFromScript((String)params[0]), (String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.WHILE_DO).setParams(2, 20).setDescription("Similar to doWhile(Task, ConditionalExpression) but the task is at least executed once.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_WhileDo(CoreTask.condFromScript((String)params[0]), (Task)params[1], (String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.PIPE_TO).setParams(20, 9).setDescription("Executes a given sub task in an isolated environment and store result as variables.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                String[] varargs = (String[])params[1];
                if (varargs != null) {
                    return new CF_PipeTo((Task)params[0], varargs);
                }
                return new CF_PipeTo((Task)params[0], new String[0]);
            }
        });
        registry.declaration(CoreActionNames.ATOMIC).setParams(20, 9).setDescription("Atomically execute a subTask while blocking on nodes present in named variables").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                String[] varargs = (String[])params[1];
                if (varargs != null) {
                    return new CF_Atomic((Task)params[0], varargs);
                }
                return new CF_Atomic((Task)params[0], new String[0]);
            }
        });
        registry.declaration(CoreActionNames.IF_THEN).setParams(2, 20).setDescription("Executes a sub task if a given condition is evaluated to true.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_IfThen(CoreTask.condFromScript((String)params[0]), (Task)params[1], (String)params[0]);
            }
        });
        registry.declaration(CoreActionNames.IF_THEN_ELSE).setParams(2, 20, 20).setDescription("Executes a sub task if a given condition is evaluated to true, another one otherwise.").setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new CF_IfThenElse(CoreTask.condFromScript((String)params[0]), (Task)params[1], (Task)params[2], (String)params[0]);
            }
        });
        registry.declaration(ActionQueryBoundedRadius.NAME).setParams(4, 5, 1, 6).setFactory(new ActionFactory(){

            @Override
            public Action create(Object[] params) {
                return new ActionQueryBoundedRadius((Integer)params[0], (Double)params[1], (Boolean)params[2], (double[])params[3]);
            }
        });
    }

    private static Task getOrCreate(Map<Integer, Task> contextTasks, String param) {
        Integer taskId = TaskHelper.parseInt(param);
        Task previous = contextTasks.get(taskId);
        if (previous == null) {
            previous = new CoreTask();
            contextTasks.put(taskId, previous);
        }
        return previous;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        HeapBuffer res = new HeapBuffer();
        HashMap<Integer, Integer> dagCounters = new HashMap<Integer, Integer>();
        HashMap<Integer, Task> dagCollector = new HashMap<Integer, Task>();
        CoreTask.deep_analyze(this, dagCounters, dagCollector);
        Set keys = dagCounters.keySet();
        Integer[] flatKeys = keys.toArray(new Integer[keys.size()]);
        HashMap<Integer, Integer> dagIDS = new HashMap<Integer, Integer>();
        for (int i = 0; i < flatKeys.length; ++i) {
            Integer key = flatKeys[i];
            Integer counter = (Integer)dagCounters.get(key);
            if (counter == null || counter <= 1) continue;
            dagIDS.put(key, dagIDS.size());
        }
        this.serialize(res, dagIDS);
        Set set_dagIDS = dagIDS.keySet();
        Integer[] flatDagIDS = set_dagIDS.toArray(new Integer[set_dagIDS.size()]);
        for (int i = 0; i < flatDagIDS.length; ++i) {
            Integer key = flatDagIDS[i];
            Integer index = (Integer)dagIDS.get(key);
            CoreTask dagTask = (CoreTask)dagCollector.get(key);
            res.writeChar('#');
            res.writeString("" + index);
            res.writeChar('{');
            dagTask.serialize(res, dagIDS);
            res.writeChar('}');
        }
        return ((Object)res).toString();
    }

    public final void serialize(Buffer builder, Map<Integer, Integer> dagCounters) {
        for (int i = 0; i < this.insertCursor; ++i) {
            if (i != 0) {
                builder.writeChar('.');
            }
            if (this.actions[i] instanceof CF_Action) {
                ((CF_Action)this.actions[i]).cf_serialize(builder, dagCounters);
                continue;
            }
            this.actions[i].serialize(builder);
        }
    }

    private static void deep_analyze(CoreTask t, Map<Integer, Integer> counters, Map<Integer, Task> dagCollector) {
        Integer tHash = t.hashCode();
        Integer previous = counters.get(tHash);
        if (previous == null) {
            counters.put(tHash, 1);
            dagCollector.put(tHash, t);
            for (int i = 0; i < t.insertCursor; ++i) {
                if (!(t.actions[i] instanceof CF_Action)) continue;
                Task[] children = ((CF_Action)t.actions[i]).children();
                for (int j = 0; j < children.length; ++j) {
                    CoreTask.deep_analyze((CoreTask)children[j], counters, dagCollector);
                }
            }
        } else {
            counters.put(tHash, previous + 1);
        }
    }

    @Override
    public final Task travelInWorld(String world) {
        return this.then(CoreActions.travelInWorld(world));
    }

    @Override
    public final Task travelInTime(String time) {
        return this.then(CoreActions.travelInTime(time));
    }

    @Override
    public final Task inject(Object input) {
        return this.then(CoreActions.inject(input));
    }

    @Override
    public final Task defineAsGlobalVar(String name) {
        return this.then(CoreActions.defineAsGlobalVar(name));
    }

    @Override
    public final Task defineAsVar(String name) {
        return this.then(CoreActions.defineAsVar(name));
    }

    @Override
    public final Task declareGlobalVar(String name) {
        return this.then(CoreActions.declareGlobalVar(name));
    }

    @Override
    public final Task declareVar(String name) {
        return this.then(CoreActions.declareVar(name));
    }

    @Override
    public final Task readVar(String name) {
        return this.then(CoreActions.readVar(name));
    }

    @Override
    public final Task setAsVar(String name) {
        return this.then(CoreActions.setAsVar(name));
    }

    @Override
    public final Task addToVar(String name) {
        return this.then(CoreActions.addToVar(name));
    }

    @Override
    public final Task setAttribute(String name, byte type, String value) {
        return this.then(CoreActions.setAttribute(name, type, value));
    }

    @Override
    public final Task timeSensitivity(String delta, String offset) {
        return this.then(CoreActions.timeSensitivity(delta, offset));
    }

    @Override
    public final Task forceAttribute(String name, byte type, String value) {
        return this.then(CoreActions.forceAttribute(name, type, value));
    }

    @Override
    public final Task remove(String name) {
        return this.then(CoreActions.remove(name));
    }

    @Override
    public final Task attributes() {
        return this.then(CoreActions.attributes());
    }

    @Override
    public Task timepoints(String from, String to) {
        return this.then(CoreActions.timepoints(from, to));
    }

    @Override
    public Task attributesWithType(byte filterType) {
        return this.then(CoreActions.attributesWithTypes(filterType));
    }

    @Override
    public final Task addVarToRelation(String relName, String varName, String ... attributes) {
        return this.then(CoreActions.addVarToRelation(relName, varName, attributes));
    }

    @Override
    public final Task removeVarFromRelation(String relName, String varFrom, String ... attributes) {
        return this.then(CoreActions.removeVarFromRelation(relName, varFrom, attributes));
    }

    @Override
    public final Task traverse(String name, String ... params) {
        return this.then(CoreActions.traverse(name, params));
    }

    @Override
    public final Task attribute(String name, String ... params) {
        return this.then(CoreActions.attribute(name, params));
    }

    @Override
    public final Task readGlobalIndex(String name, String ... query) {
        return this.then(CoreActions.readGlobalIndex(name, query));
    }

    @Override
    public Task globalIndex(String indexName) {
        return this.then(CoreActions.globalIndex(indexName));
    }

    @Override
    public final Task addToGlobalIndex(String name, String ... attributes) {
        return this.then(CoreActions.addToGlobalIndex(name, attributes));
    }

    @Override
    public final Task addToGlobalTimedIndex(String name, String ... attributes) {
        return this.then(CoreActions.addToGlobalTimedIndex(name, attributes));
    }

    @Override
    public final Task removeFromGlobalIndex(String name, String ... attributes) {
        return this.then(CoreActions.removeFromGlobalIndex(name, attributes));
    }

    @Override
    public final Task removeFromGlobalTimedIndex(String name, String ... attributes) {
        return this.then(CoreActions.removeFromGlobalTimedIndex(name, attributes));
    }

    @Override
    public final Task indexNames() {
        return this.then(CoreActions.indexNames());
    }

    @Override
    public final Task selectWith(String name, String pattern) {
        return this.then(CoreActions.selectWith(name, pattern));
    }

    @Override
    public final Task selectWithout(String name, String pattern) {
        return this.then(CoreActions.selectWithout(name, pattern));
    }

    @Override
    public final Task select(TaskFunctionSelect filterFunction) {
        return this.then(CoreActions.select(filterFunction));
    }

    @Override
    public final Task selectObject(TaskFunctionSelectObject filterFunction) {
        return this.then(CoreActions.selectObject(filterFunction));
    }

    @Override
    public Task log(String name) {
        return this.then(CoreActions.log(name));
    }

    @Override
    public final Task selectScript(String script) {
        return this.then(CoreActions.selectScript(script));
    }

    @Override
    public final Task print(String name) {
        return this.then(CoreActions.print(name));
    }

    @Override
    public final Task println(String name) {
        return this.then(CoreActions.println(name));
    }

    @Override
    public final Task executeExpression(String expression) {
        return this.then(CoreActions.executeExpression(expression));
    }

    @Override
    public final Task createNode() {
        return this.then(CoreActions.createNode());
    }

    @Override
    public final Task createTypedNode(String type) {
        return this.then(CoreActions.createTypedNode(type));
    }

    @Override
    public final Task save() {
        return this.then(CoreActions.save());
    }

    @Override
    public final Task script(String script) {
        return this.then(CoreActions.script(script));
    }

    @Override
    public final Task asyncScript(String ascript) {
        return this.then(CoreActions.asyncScript(ascript));
    }

    @Override
    public final Task lookup(String nodeId) {
        return this.then(CoreActions.lookup(nodeId));
    }

    @Override
    public final Task lookupAll(String nodeIds) {
        return this.then(CoreActions.lookupAll(nodeIds));
    }

    @Override
    public final Task clearResult() {
        return this.then(CoreActions.clearResult());
    }

    @Override
    public final Task action(String name, String ... params) {
        return this.then(CoreActions.action(name, params));
    }

    @Override
    public final Task flipVar(String name) {
        return this.then(CoreActions.flipVar(name));
    }

    @Override
    public final Task flat() {
        return this.then(CoreActions.flat());
    }
}

