/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Action;
import greycat.Callback;
import greycat.Graph;
import greycat.Node;
import greycat.TaskContext;
import greycat.TaskHook;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.base.BaseNode;
import greycat.base.BaseTaskResult;
import greycat.internal.task.CoreTask;
import greycat.internal.task.TaskHelper;
import greycat.internal.task.math.CoreMathExpressionEngine;
import greycat.internal.task.math.MathExpressionEngine;
import greycat.utility.Tuple;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class CoreTaskContext
implements TaskContext {
    private final Map<String, TaskResult> _globalVariables;
    private final TaskContext _parent;
    private final Graph _graph;
    final Callback<TaskResult> _callback;
    private Map<String, TaskResult> _localVariables = null;
    private Map<String, TaskResult> _nextVariables = null;
    TaskResult _result;
    private long _world;
    private long _time;
    private final CoreTask _origin;
    private int cursor = 0;
    final TaskHook[] _hooks;
    private StringBuilder _output = null;

    CoreTaskContext(CoreTask origin, TaskHook[] p_hooks, TaskContext parentContext, TaskResult initial, Graph p_graph, Callback<TaskResult> p_callback) {
        this._origin = origin;
        this._hooks = p_hooks;
        if (parentContext != null) {
            this._time = parentContext.time();
            this._world = parentContext.world();
        } else {
            this._world = 0L;
            this._time = -9007199254740990L;
        }
        this._graph = p_graph;
        this._parent = parentContext;
        CoreTaskContext castedParentContext = (CoreTaskContext)parentContext;
        this._globalVariables = parentContext == null ? new ConcurrentHashMap<String, TaskResult>() : castedParentContext.globalVariables();
        this._result = initial;
        this._callback = p_callback;
    }

    @Override
    public final Graph graph() {
        return this._graph;
    }

    @Override
    public final long world() {
        return this._world;
    }

    @Override
    public final TaskContext setWorld(long p_world) {
        this._world = p_world;
        return this;
    }

    @Override
    public final long time() {
        return this._time;
    }

    @Override
    public final TaskContext setTime(long p_time) {
        this._time = p_time;
        return this;
    }

    @Override
    public Tuple<String, TaskResult>[] variables() {
        HashMap<String, TaskResult> collected = new HashMap<String, TaskResult>();
        String[] globalKeys = this._globalVariables.keySet().toArray(new String[this._globalVariables.size()]);
        for (int i = 0; i < globalKeys.length; ++i) {
            collected.put(globalKeys[i], this._globalVariables.get(globalKeys[i]));
        }
        String[] collectedKeys = collected.keySet().toArray(new String[collected.size()]);
        Tuple[] result = new Tuple[collectedKeys.length];
        for (int i = 0; i < collectedKeys.length; ++i) {
            result[i] = new Tuple(collectedKeys[i], collected.get(collectedKeys[i]));
        }
        return result;
    }

    private void recursive_collect(TaskContext ctx, Map<String, TaskResult> collector) {
        Map<String, TaskResult> localVariables = ((CoreTaskContext)ctx).localVariables();
        if (localVariables != null) {
            String[] localKeys = localVariables.keySet().toArray(new String[localVariables.size()]);
            for (int i = 0; i < localKeys.length; ++i) {
                if (collector.containsKey(localKeys[i])) continue;
                collector.put(localKeys[i], localVariables.get(localKeys[i]));
            }
        }
        if (((CoreTaskContext)ctx)._parent != null) {
            this.recursive_collect(((CoreTaskContext)ctx)._parent, collector);
        }
    }

    @Override
    public final TaskResult variable(String name) {
        TaskResult resolved = this._globalVariables.get(name);
        if (resolved == null) {
            resolved = this.internal_deep_resolve(name);
        }
        return resolved;
    }

    @Override
    public int intVar(String name) {
        TaskResult res = this.variable(name);
        if (res != null && res.size() > 0) {
            return (Integer)res.get(0);
        }
        return -1;
    }

    @Override
    public double doubleVar(String name) {
        TaskResult res = this.variable(name);
        if (res != null && res.size() > 0) {
            return (Double)res.get(0);
        }
        return -1.0;
    }

    @Override
    public long longVar(String name) {
        TaskResult res = this.variable(name);
        if (res != null && res.size() > 0) {
            return (Long)res.get(0);
        }
        return -1L;
    }

    @Override
    public boolean isGlobal(String name) {
        return this._globalVariables.containsKey(name);
    }

    private TaskResult internal_deep_resolve(String name) {
        TaskResult resolved = null;
        if (this._localVariables != null) {
            resolved = this._localVariables.get(name);
        }
        if (resolved == null && this._parent != null) {
            CoreTaskContext castedParent = (CoreTaskContext)this._parent;
            if (castedParent._nextVariables != null && (resolved = castedParent._nextVariables.get(name)) != null) {
                return resolved;
            }
            return castedParent.internal_deep_resolve(name);
        }
        return resolved;
    }

    @Override
    public TaskResult wrap(Object input) {
        return new BaseTaskResult(input, false);
    }

    @Override
    public TaskResult wrapClone(Object input) {
        return new BaseTaskResult(input, true);
    }

    @Override
    public TaskResult newResult() {
        return new BaseTaskResult(null, false);
    }

    @Override
    public TaskContext declareVariable(String name) {
        if (this._localVariables == null) {
            this._localVariables = new HashMap<String, TaskResult>();
        }
        this._localVariables.put(name, new BaseTaskResult(null, false));
        return this;
    }

    private TaskResult lazyWrap(Object input) {
        if (input instanceof BaseTaskResult) {
            return (TaskResult)input;
        }
        return this.wrap(input);
    }

    @Override
    public TaskContext defineVariable(String name, Object initialResult) {
        if (this._localVariables == null) {
            this._localVariables = new HashMap<String, TaskResult>();
        }
        this._localVariables.put(name, this.lazyWrap(initialResult).clone());
        return this;
    }

    @Override
    public TaskContext defineVariableForSubTask(String name, Object initialResult) {
        if (this._nextVariables == null) {
            this._nextVariables = new HashMap<String, TaskResult>();
        }
        this._nextVariables.put(name, this.lazyWrap(initialResult).clone());
        return this;
    }

    @Override
    public final TaskContext setGlobalVariable(String name, Object value) {
        TaskResult previous = this._globalVariables.put(name, this.lazyWrap(value).clone());
        if (previous != null) {
            previous.free();
        }
        return this;
    }

    @Override
    public final TaskContext setVariable(String name, Object value) {
        TaskResult previous;
        Map<String, TaskResult> target = this.internal_deep_resolve_map(name);
        if (target == null) {
            if (this._localVariables == null) {
                this._localVariables = new HashMap<String, TaskResult>();
            }
            target = this._localVariables;
        }
        if ((previous = target.put(name, this.lazyWrap(value).clone())) != null) {
            previous.free();
        }
        return this;
    }

    private Map<String, TaskResult> internal_deep_resolve_map(String name) {
        TaskResult resolved;
        if (this._localVariables != null && (resolved = this._localVariables.get(name)) != null) {
            return this._localVariables;
        }
        if (this._parent != null) {
            TaskResult resolved2;
            CoreTaskContext castedParent = (CoreTaskContext)this._parent;
            if (castedParent._nextVariables != null && (resolved2 = castedParent._nextVariables.get(name)) != null) {
                return this._localVariables;
            }
            return ((CoreTaskContext)this._parent).internal_deep_resolve_map(name);
        }
        return null;
    }

    @Override
    public final TaskContext addToGlobalVariable(String name, Object value) {
        BaseTaskResult<Object> previous = this._globalVariables.get(name);
        if (previous == null) {
            previous = new BaseTaskResult<Object>(null, false);
            this._globalVariables.put(name, previous);
        }
        if (value != null) {
            if (value instanceof BaseTaskResult) {
                TaskResult casted = (TaskResult)value;
                for (int i = 0; i < casted.size(); ++i) {
                    Object loop = casted.get(i);
                    if (loop instanceof BaseNode) {
                        Node castedNode = (Node)loop;
                        previous.add(castedNode.graph().cloneNode(castedNode));
                        continue;
                    }
                    previous.add(loop);
                }
            } else if (value instanceof BaseNode) {
                Node castedNode = (Node)value;
                previous.add(castedNode.graph().cloneNode(castedNode));
            } else {
                previous.add(value);
            }
        }
        return this;
    }

    @Override
    public final TaskContext addToVariable(String name, Object value) {
        BaseTaskResult<Object> previous;
        Map<String, TaskResult> target = this.internal_deep_resolve_map(name);
        if (target == null) {
            if (this._localVariables == null) {
                this._localVariables = new HashMap<String, TaskResult>();
            }
            target = this._localVariables;
        }
        if ((previous = target.get(name)) == null) {
            previous = new BaseTaskResult<Object>(null, false);
            target.put(name, previous);
        }
        if (value != null) {
            if (value instanceof BaseTaskResult) {
                TaskResult casted = (TaskResult)value;
                for (int i = 0; i < casted.size(); ++i) {
                    Object loop = casted.get(i);
                    if (loop instanceof BaseNode) {
                        Node castedNode = (Node)loop;
                        previous.add(castedNode.graph().cloneNode(castedNode));
                        continue;
                    }
                    previous.add(loop);
                }
            } else if (value instanceof BaseNode) {
                Node castedNode = (Node)value;
                previous.add(castedNode.graph().cloneNode(castedNode));
            } else {
                previous.add(value);
            }
        }
        return this;
    }

    Map<String, TaskResult> globalVariables() {
        return this._globalVariables;
    }

    Map<String, TaskResult> localVariables() {
        return this._localVariables;
    }

    @Override
    public final TaskResult result() {
        return this._result;
    }

    @Override
    public TaskResult<Node> resultAsNodes() {
        return this._result;
    }

    @Override
    public TaskResult<String> resultAsStrings() {
        return this._result;
    }

    @Override
    public final void continueWith(TaskResult nextResult) {
        TaskResult previousResult = this._result;
        if (previousResult != null && previousResult != nextResult) {
            previousResult.free();
        }
        this._result = nextResult;
        this.continueTask();
    }

    @Override
    public final void continueTask() {
        int i;
        TaskHook[] globalHooks = this._graph.taskHooks();
        Action currentAction = this._origin.actions[this.cursor];
        if (this._hooks != null) {
            for (i = 0; i < this._hooks.length; ++i) {
                this._hooks[i].afterAction(currentAction, this);
            }
        }
        if (globalHooks != null) {
            for (i = 0; i < globalHooks.length; ++i) {
                globalHooks[i].afterAction(currentAction, this);
            }
        }
        ++this.cursor;
        Action nextAction = this.cursor == this._origin.insertCursor ? null : this._origin.actions[this.cursor];
        if (nextAction == null) {
            this.endTask(null, null);
        } else {
            int i2;
            if (this._hooks != null) {
                for (i2 = 0; i2 < this._hooks.length; ++i2) {
                    this._hooks[i2].beforeAction(nextAction, this);
                }
            }
            if (globalHooks != null) {
                for (i2 = 0; i2 < globalHooks.length; ++i2) {
                    globalHooks[i2].beforeAction(nextAction, this);
                }
            }
            int previousCursot = this.cursor;
            try {
                nextAction.eval(this);
            }
            catch (Exception e) {
                if (this.cursor == previousCursot) {
                    this.endTask(null, e);
                }
                e.printStackTrace();
            }
        }
    }

    @Override
    public void endTask(TaskResult preFinalResult, Exception e) {
        int i;
        if (preFinalResult != null) {
            if (this._result != null) {
                this._result.free();
            }
            this._result = preFinalResult;
        }
        TaskHook[] globalHooks = this._graph.taskHooks();
        if (this._localVariables != null) {
            Set<String> localValues = this._localVariables.keySet();
            String[] flatLocalValues = localValues.toArray(new String[localValues.size()]);
            for (i = 0; i < flatLocalValues.length; ++i) {
                this._localVariables.get(flatLocalValues[i]).free();
            }
        }
        if (this._nextVariables != null) {
            Set<String> nextValues = this._nextVariables.keySet();
            String[] flatNextValues = nextValues.toArray(new String[nextValues.size()]);
            for (i = 0; i < flatNextValues.length; ++i) {
                this._nextVariables.get(flatNextValues[i]).free();
            }
        }
        if (this._parent == null) {
            Set<String> globalValues = this._globalVariables.keySet();
            String[] globalFlatValues = globalValues.toArray(new String[globalValues.size()]);
            for (i = 0; i < globalFlatValues.length; ++i) {
                this._globalVariables.get(globalFlatValues[i]).free();
            }
        }
        if (this._hooks != null) {
            for (int i2 = 0; i2 < this._hooks.length; ++i2) {
                if (this._parent == null) {
                    this._hooks[i2].end(this);
                    continue;
                }
                this._hooks[i2].afterTask(this);
            }
        }
        if (globalHooks != null) {
            for (int i3 = 0; i3 < globalHooks.length; ++i3) {
                if (this._parent == null) {
                    globalHooks[i3].end(this);
                    continue;
                }
                globalHooks[i3].afterTask(this);
            }
        }
        if (this._callback != null) {
            if (e != null) {
                if (this._result == null) {
                    this._result = new BaseTaskResult(null, false);
                }
                this._result.setException(e);
            }
            if (this._output != null) {
                if (this._result == null) {
                    this._result = new BaseTaskResult(null, false);
                }
                this._result.setOutput(this._output.toString());
            }
            this._callback.on(this._result);
        } else {
            if (e != null) {
                e.printStackTrace();
            }
            if (this._output != null) {
                System.out.print(this._output.toString());
            }
            if (this._result != null) {
                this._result.free();
            }
        }
    }

    final void execute() {
        TaskHook[] globalHooks;
        Action current = this._origin.actions[this.cursor];
        if (this._hooks != null) {
            for (int i = 0; i < this._hooks.length; ++i) {
                if (this._parent == null) {
                    this._hooks[i].start(this);
                } else {
                    this._hooks[i].beforeTask(this._parent, this);
                }
                this._hooks[i].beforeAction(current, this);
            }
        }
        if ((globalHooks = this._graph.taskHooks()) != null) {
            for (int i = 0; i < globalHooks.length; ++i) {
                if (this._parent == null) {
                    globalHooks[i].start(this);
                } else {
                    globalHooks[i].beforeTask(this._parent, this);
                }
                globalHooks[i].beforeAction(current, this);
            }
        }
        try {
            current.eval(this);
        }
        catch (Exception e) {
            if (this.cursor == 0) {
                this.endTask(null, e);
            }
            e.printStackTrace();
        }
    }

    @Override
    public final String template(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder buffer = null;
        int previousPos = -1;
        for (int cursor = 0; cursor < input.length(); ++cursor) {
            char currentChar = input.charAt(cursor);
            int previousChar = 48;
            int nextChar = 48;
            if (cursor > 0) {
                previousChar = input.charAt(cursor - 1);
            }
            if (cursor + 1 < input.length()) {
                nextChar = input.charAt(cursor + 1);
            }
            if (currentChar == '{' && previousChar == 123) {
                previousPos = cursor + 1;
                continue;
            }
            if (previousPos != -1 && currentChar == '}' && previousChar == 125) {
                String contextKey;
                if (buffer == null) {
                    buffer = new StringBuilder();
                    buffer.append(input.substring(0, previousPos - 2));
                }
                if ((contextKey = input.substring(previousPos, cursor - 1).trim()).length() > 0 && contextKey.charAt(0) == '=') {
                    MathExpressionEngine mathEngine = CoreMathExpressionEngine.parse(contextKey.substring(1));
                    double value = mathEngine.eval(null, this, new HashMap<String, Double>());
                    String valueStr = value + "";
                    for (int i = valueStr.length() - 1; i >= 0; --i) {
                        if (valueStr.charAt(i) == '.') {
                            valueStr = valueStr.substring(0, i);
                            break;
                        }
                        if (valueStr.charAt(i) != '0') break;
                    }
                    buffer.append(valueStr);
                } else {
                    TaskResult foundVar;
                    int indexArray = -1;
                    if (contextKey.charAt(contextKey.length() - 1) == ']') {
                        int indexStart = -1;
                        for (int i = contextKey.length() - 3; i >= 0; --i) {
                            if (contextKey.charAt(i) != '[') continue;
                            indexStart = i + 1;
                            break;
                        }
                        if (indexStart != -1) {
                            indexArray = TaskHelper.parseInt(contextKey.substring(indexStart, contextKey.length() - 1));
                            contextKey = contextKey.substring(0, indexStart - 1);
                            if (indexArray < 0) {
                                throw new RuntimeException("Array index out of range: " + indexArray);
                            }
                        }
                    }
                    if ((foundVar = this.variable(contextKey)) == null) {
                        switch (contextKey) {
                            case "result": {
                                foundVar = this.result();
                                break;
                            }
                            case "time": {
                                foundVar = this.wrap(this._time);
                                break;
                            }
                            case "world": {
                                foundVar = this.wrap(this._world);
                            }
                        }
                    }
                    if (foundVar != null) {
                        if (foundVar.size() == 1 || indexArray != -1) {
                            Object toShow = null;
                            toShow = indexArray == -1 ? foundVar.get(0) : foundVar.get(indexArray);
                            buffer.append((Object)toShow);
                        } else {
                            TaskResultIterator it = foundVar.iterator();
                            buffer.append("[");
                            boolean isFirst = true;
                            Object next = it.next();
                            while (next != null) {
                                if (isFirst) {
                                    isFirst = false;
                                } else {
                                    buffer.append(",");
                                }
                                buffer.append(next);
                                next = it.next();
                            }
                            buffer.append("]");
                        }
                    }
                }
                previousPos = -1;
                continue;
            }
            if (previousPos != -1 || buffer == null || currentChar == '{' && nextChar == 123) continue;
            buffer.append(input.charAt(cursor));
        }
        if (buffer == null) {
            return input;
        }
        return buffer.toString();
    }

    @Override
    public final String[] templates(String[] inputs) {
        if (inputs == null) {
            return null;
        }
        String[] result = new String[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            result[i] = this.template(inputs[i]);
        }
        return result;
    }

    @Override
    public final synchronized void append(String additionalOutput) {
        if (this._output == null) {
            this._output = new StringBuilder();
        }
        this._output.append(additionalOutput);
    }

    public final String toString() {
        return "{result:" + this._result.toString() + "}";
    }
}

