/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task;

import greycat.Node;
import greycat.Type;
import greycat.base.BaseNode;
import greycat.struct.Buffer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class TaskHelper {
    static final ScriptEngine SCRIPT_ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");

    public static Node[] flatNodes(Object toFLat, boolean strict) {
        if (toFLat instanceof BaseNode) {
            return new Node[]{(Node)toFLat};
        }
        if (toFLat instanceof Object[]) {
            Object[] resAsArray = (Object[])toFLat;
            Node[] nodes = new Node[]{};
            for (int i = 0; i < resAsArray.length; ++i) {
                if (resAsArray[i] instanceof BaseNode) {
                    Node[] tmp = new Node[nodes.length + 1];
                    System.arraycopy(nodes, 0, tmp, 0, nodes.length);
                    tmp[nodes.length] = (BaseNode)resAsArray[i];
                    nodes = tmp;
                    continue;
                }
                if (resAsArray[i] instanceof Object[]) {
                    Node[] innerNodes = TaskHelper.flatNodes(resAsArray[i], strict);
                    Node[] tmp = new Node[nodes.length + innerNodes.length];
                    System.arraycopy(nodes, 0, tmp, 0, nodes.length);
                    System.arraycopy(innerNodes, 0, tmp, nodes.length, innerNodes.length);
                    nodes = tmp;
                    continue;
                }
                if (!strict) continue;
                throw new RuntimeException("[ActionAddRemoveToGlobalIndex] The array in result contains an element with wrong type. Expected type: BaseNode. Actual type: " + resAsArray[i]);
            }
            return nodes;
        }
        if (strict) {
            throw new RuntimeException("[ActionAddRemoveToGlobalIndex] Wrong type of result. Expected type is BaseNode or an array of BaseNode.Actual type is " + toFLat);
        }
        return new Node[0];
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s);
    }

    public static void serializeString(String param, Buffer builder, boolean singleQuote) {
        if (singleQuote) {
            builder.writeString("'");
        } else {
            builder.writeString("\"");
        }
        boolean escapteActivated = false;
        boolean previousIsEscape = false;
        if (param != null) {
            for (int i = 0; i < param.length(); ++i) {
                char current = param.charAt(i);
                if (current == '\r' || current == '\n') {
                    if (!escapteActivated) {
                        escapteActivated = true;
                        builder.writeString(param.substring(0, i));
                    }
                } else if (singleQuote && current == '\'' || !singleQuote && current == '\"') {
                    if (!escapteActivated) {
                        escapteActivated = true;
                        builder.writeString(param.substring(0, i));
                    }
                    if (!previousIsEscape) {
                        builder.writeChar('\\');
                    }
                    builder.writeChar(param.charAt(i));
                } else if (escapteActivated) {
                    builder.writeChar(param.charAt(i));
                }
                previousIsEscape = current == '\\';
            }
        }
        if (!escapteActivated && param != null) {
            builder.writeString(param);
        }
        if (singleQuote) {
            builder.writeString("'");
        } else {
            builder.writeString("\"");
        }
    }

    public static void serializeType(byte type, Buffer builder) {
        builder.writeString(Type.typeName(type));
    }

    public static void serializeStringParams(String[] params, Buffer builder) {
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                builder.writeChar(',');
            }
            TaskHelper.serializeString(params[i], builder, true);
        }
    }

    public static void serializeNameAndStringParams(String name, String[] params, Buffer builder) {
        builder.writeString(name);
        builder.writeChar('(');
        TaskHelper.serializeStringParams(params, builder);
        builder.writeChar(')');
    }
}

