/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task.math;

import greycat.Node;
import greycat.TaskContext;
import greycat.TaskResult;
import greycat.internal.task.math.MathDoubleToken;
import greycat.internal.task.math.MathEntities;
import greycat.internal.task.math.MathExpressionEngine;
import greycat.internal.task.math.MathExpressionTokenizer;
import greycat.internal.task.math.MathFreeToken;
import greycat.internal.task.math.MathFunction;
import greycat.internal.task.math.MathOperation;
import greycat.internal.task.math.MathToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class CoreMathExpressionEngine
implements MathExpressionEngine {
    static final char decimalSeparator = '.';
    static final char minusSign = '-';
    private final MathToken[] _cacheAST;

    private CoreMathExpressionEngine(String expression) {
        this._cacheAST = this.buildAST(this.shuntingYard(expression));
    }

    public static synchronized MathExpressionEngine parse(String p_expression) {
        return new CoreMathExpressionEngine(p_expression);
    }

    static boolean isNumber(String st) {
        if (st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        for (int i = 0; i < st.length(); ++i) {
            char ch = st.charAt(i);
            if (CoreMathExpressionEngine.isDigit(ch) || ch == '-' || ch == '.') continue;
            return false;
        }
        return true;
    }

    static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    private List<String> shuntingYard(String expression) {
        ArrayList<String> outputQueue = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        MathExpressionTokenizer tokenizer = new MathExpressionTokenizer(expression);
        String lastFunction = null;
        String previousToken = null;
        while (tokenizer.hasNext()) {
            String token = tokenizer.next();
            if (MathEntities.getINSTANCE().functions.keySet().contains(token.toUpperCase())) {
                stack.push(token);
                lastFunction = token;
            } else if (",".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new RuntimeException("Parse error for function '" + lastFunction + "'");
                }
            } else if (MathEntities.getINSTANCE().operators.keySet().contains(token)) {
                String token2;
                MathOperation o1 = MathEntities.getINSTANCE().operators.get(token);
                String string = token2 = stack.isEmpty() ? null : (String)stack.peek();
                while (MathEntities.getINSTANCE().operators.keySet().contains(token2) && (o1.isLeftAssoc() && o1.getPrecedence() <= MathEntities.getINSTANCE().operators.get(token2).getPrecedence() || o1.getPrecedence() < MathEntities.getINSTANCE().operators.get(token2).getPrecedence())) {
                    outputQueue.add((String)stack.pop());
                    token2 = stack.isEmpty() ? null : (String)stack.peek();
                }
                stack.push(token);
            } else if ("(".equals(token)) {
                if (previousToken != null && CoreMathExpressionEngine.isNumber(previousToken)) {
                    throw new RuntimeException("Missing operator at character position " + tokenizer.getPos());
                }
                stack.push(token);
            } else if (")".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new RuntimeException("Mismatched parentheses");
                }
                stack.pop();
                if (!stack.isEmpty() && MathEntities.getINSTANCE().functions.keySet().contains(((String)stack.peek()).toUpperCase())) {
                    outputQueue.add((String)stack.pop());
                }
            } else {
                outputQueue.add(token);
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            String element = (String)stack.pop();
            if ("(".equals(element) || ")".equals(element)) {
                throw new RuntimeException("Mismatched parentheses");
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    @Override
    public final double eval(Node context, TaskContext taskContext, Map<String, Double> variables) {
        if (this._cacheAST == null) {
            throw new RuntimeException("Call parse before");
        }
        Stack<Double> stack = new Stack<Double>();
        block8: for (int ii = 0; ii < this._cacheAST.length; ++ii) {
            MathToken mathToken = this._cacheAST[ii];
            switch (mathToken.type()) {
                case 0: {
                    double v1 = (Double)stack.pop();
                    double v2 = (Double)stack.pop();
                    MathOperation castedOp = (MathOperation)mathToken;
                    stack.push(castedOp.eval(v2, v1));
                    continue block8;
                }
                case 1: {
                    MathFunction castedFunction = (MathFunction)mathToken;
                    double[] p = new double[castedFunction.getNumParams()];
                    for (int i = castedFunction.getNumParams() - 1; i >= 0; --i) {
                        p[i] = (Double)stack.pop();
                    }
                    stack.push(castedFunction.eval(p));
                    continue block8;
                }
                case 2: {
                    MathDoubleToken castedDouble = (MathDoubleToken)mathToken;
                    stack.push(castedDouble.content());
                    continue block8;
                }
                case 3: {
                    MathFreeToken castedFreeToken = (MathFreeToken)mathToken;
                    Double resolvedVar = null;
                    if (variables != null) {
                        resolvedVar = variables.get(castedFreeToken.content());
                    }
                    if (resolvedVar != null) {
                        stack.push(resolvedVar);
                        continue block8;
                    }
                    if ("TIME".equals(castedFreeToken.content())) {
                        stack.push(Double.valueOf(context.time()));
                        continue block8;
                    }
                    String tokenName = castedFreeToken.content().trim();
                    Object resolved = null;
                    String cleanName = null;
                    if (context != null) {
                        if (tokenName.length() > 0 && tokenName.charAt(0) == '{' && tokenName.charAt(tokenName.length() - 1) == '}') {
                            resolved = context.get(castedFreeToken.content().substring(1, tokenName.length() - 1));
                            cleanName = castedFreeToken.content().substring(1, tokenName.length() - 1);
                        } else {
                            resolved = context.get(castedFreeToken.content());
                            cleanName = castedFreeToken.content();
                        }
                        if (cleanName.length() > 0 && cleanName.charAt(0) == '$') {
                            cleanName = cleanName.substring(1);
                        }
                    }
                    if (taskContext != null && resolved == null) {
                        if (tokenName.charAt(tokenName.length() - 1) == ']') {
                            TaskResult varRes;
                            int indexStart = -1;
                            int indexArray = -1;
                            for (int i = tokenName.length() - 3; i >= 0; --i) {
                                if (tokenName.charAt(i) != '[') continue;
                                indexStart = i + 1;
                                break;
                            }
                            if (indexStart != -1) {
                                indexArray = this.parseInt(tokenName.substring(indexStart, tokenName.length() - 1));
                                tokenName = tokenName.substring(0, indexStart - 1);
                            }
                            if ((varRes = taskContext.variable(tokenName)) == null && tokenName.equals("result")) {
                                varRes = taskContext.result();
                            }
                            if (varRes != null && varRes.size() > indexArray) {
                                resolved = varRes.get(indexArray);
                            }
                        } else {
                            TaskResult varRes = taskContext.variable(tokenName);
                            if (varRes == null && tokenName.equals("result")) {
                                varRes = taskContext.result();
                            }
                            if (varRes != null) {
                                resolved = varRes.get(0);
                            }
                        }
                    }
                    if (resolved != null) {
                        double resultAsDouble = this.parseDouble(resolved.toString());
                        variables.put(cleanName, resultAsDouble);
                        String valueString = resolved.toString();
                        if (valueString.equals("true")) {
                            stack.push(1.0);
                            continue block8;
                        }
                        if (valueString.equals("false")) {
                            stack.push(0.0);
                            continue block8;
                        }
                        try {
                            stack.push(resultAsDouble);
                        }
                        catch (Exception exception) {}
                        continue block8;
                    }
                    throw new RuntimeException("Unknow variable for name " + castedFreeToken.content());
                }
            }
        }
        Double result = (Double)stack.pop();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private MathToken[] buildAST(List<String> rpn) {
        MathToken[] result = new MathToken[rpn.size()];
        for (int ii = 0; ii < rpn.size(); ++ii) {
            String token = rpn.get(ii);
            if (MathEntities.getINSTANCE().operators.keySet().contains(token)) {
                result[ii] = MathEntities.getINSTANCE().operators.get(token);
                continue;
            }
            if (MathEntities.getINSTANCE().functions.keySet().contains(token.toUpperCase())) {
                result[ii] = MathEntities.getINSTANCE().functions.get(token.toUpperCase());
                continue;
            }
            if (token.length() > 0 && CoreMathExpressionEngine.isLetter(token.charAt(0))) {
                result[ii] = new MathFreeToken(token);
                continue;
            }
            try {
                double parsed = this.parseDouble(token);
                result[ii] = new MathDoubleToken(parsed);
                continue;
            }
            catch (Exception e) {
                result[ii] = new MathFreeToken(token);
            }
        }
        return result;
    }

    private double parseDouble(String val) {
        return Double.parseDouble(val);
    }

    private int parseInt(String val) {
        return Integer.parseInt(val);
    }
}

