/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task.math;

import greycat.internal.task.math.CoreMathExpressionEngine;
import greycat.internal.task.math.MathEntities;

class MathExpressionTokenizer {
    private int pos = 0;
    private String input;
    private String previousToken;

    MathExpressionTokenizer(String input) {
        this.input = input.trim();
    }

    boolean hasNext() {
        return this.pos < this.input.length();
    }

    private char peekNextChar() {
        if (this.pos < this.input.length() - 1) {
            return this.input.charAt(this.pos + 1);
        }
        return '\u0000';
    }

    String next() {
        StringBuilder token = new StringBuilder();
        if (this.pos >= this.input.length()) {
            this.previousToken = null;
            return null;
        }
        char ch = this.input.charAt(this.pos);
        while (CoreMathExpressionEngine.isWhitespace(ch) && this.pos < this.input.length()) {
            ch = this.input.charAt(++this.pos);
        }
        if (CoreMathExpressionEngine.isDigit(ch)) {
            while ((CoreMathExpressionEngine.isDigit(ch) || ch == '.') && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
        } else if (ch == '-' && CoreMathExpressionEngine.isDigit(this.peekNextChar()) && ("(".equals(this.previousToken) || ",".equals(this.previousToken) || this.previousToken == null || MathEntities.getINSTANCE().operators.keySet().contains(this.previousToken))) {
            token.append('-');
            ++this.pos;
            token.append(this.next());
        } else if (CoreMathExpressionEngine.isLetter(ch) || ch == '_' || ch == '{' || ch == '}' || ch == '$') {
            while ((CoreMathExpressionEngine.isLetter(ch) || CoreMathExpressionEngine.isDigit(ch) || ch == '_' || ch == '{' || ch == '}' || ch == '$') && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
            if (this.pos < this.input.length() && this.input.charAt(this.pos) == '[') {
                token.append(this.input.charAt(this.pos++));
                char c = ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                while (CoreMathExpressionEngine.isDigit(ch) && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                if (this.input.charAt(this.pos) != ']') {
                    throw new RuntimeException("Error in array definition '" + token + "' at position " + (this.pos - token.length() + 1));
                }
                token.append(this.input.charAt(this.pos++));
            }
        } else if (ch == '(' || ch == ')' || ch == ',') {
            token.append(ch);
            ++this.pos;
        } else {
            while (!(CoreMathExpressionEngine.isLetter(ch) || CoreMathExpressionEngine.isDigit(ch) || ch == '_' || CoreMathExpressionEngine.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || ch == '{' || ch == '}' || ch == '$' || this.pos >= this.input.length())) {
                token.append(this.input.charAt(this.pos));
                ++this.pos;
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                if (ch != '-') continue;
            }
            if (!MathEntities.getINSTANCE().operators.keySet().contains(token.toString())) {
                throw new RuntimeException("Unknown operator '" + token + "' at position " + (this.pos - token.length() + 1));
            }
        }
        this.previousToken = token.toString();
        return this.previousToken;
    }

    int getPos() {
        return this.pos;
    }
}

