/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task.math;

import greycat.internal.task.math.MathToken;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class MathFunction
implements MathToken {
    private String name;
    private int numParams;
    private TimeZone timeZone = TimeZone.getDefault();
    private Locale locale = Locale.getDefault(Locale.Category.FORMAT);

    MathFunction(String name, int numParams) {
        this.name = name.toUpperCase();
        this.numParams = numParams;
    }

    public String getName() {
        return this.name;
    }

    int getNumParams() {
        return this.numParams;
    }

    double eval(double[] p) {
        if (this.name.equals("NOT")) {
            return p[0] == 0.0 ? 1.0 : 0.0;
        }
        if (this.name.equals("IF")) {
            return p[0] != 0.0 ? p[1] : p[2];
        }
        if (this.name.equals("RAND")) {
            return Math.random();
        }
        if (this.name.equals("SIN")) {
            return Math.sin(p[0]);
        }
        if (this.name.equals("COS")) {
            return Math.cos(p[0]);
        }
        if (this.name.equals("TAN")) {
            return Math.tan(p[0]);
        }
        if (this.name.equals("ASIN")) {
            return Math.asin(p[0]);
        }
        if (this.name.equals("ACOS")) {
            return Math.acos(p[0]);
        }
        if (this.name.equals("ATAN")) {
            return Math.atan(p[0]);
        }
        if (this.name.equals("MAX")) {
            return p[0] > p[1] ? p[0] : p[1];
        }
        if (this.name.equals("MIN")) {
            return p[0] < p[1] ? p[0] : p[1];
        }
        if (this.name.equals("ABS")) {
            return Math.abs(p[0]);
        }
        if (this.name.equals("LOG")) {
            return Math.log(p[0]);
        }
        if (this.name.equals("ROUND")) {
            long factor = (long)Math.pow(10.0, p[1]);
            double value = p[0] * (double)factor;
            long tmp = Math.round(value);
            return (double)tmp / (double)factor;
        }
        if (this.name.equals("FLOOR")) {
            return Math.floor(p[0]);
        }
        if (this.name.equals("CEILING")) {
            return Math.ceil(p[0]);
        }
        if (this.name.equals("SQRT")) {
            return Math.sqrt(p[0]);
        }
        if (this.name.equals("SECONDS")) {
            return this.date_to_seconds(p[0]);
        }
        if (this.name.equals("MINUTES")) {
            return this.date_to_minutes(p[0]);
        }
        if (this.name.equals("HOURS")) {
            return this.date_to_hours(p[0]);
        }
        if (this.name.equals("DAY")) {
            return this.date_to_days(p[0]);
        }
        if (this.name.equals("MONTH")) {
            return this.date_to_months(p[0]);
        }
        if (this.name.equals("YEAR")) {
            return this.date_to_year(p[0]);
        }
        if (this.name.equals("DAYOFWEEK")) {
            return this.date_to_dayofweek(p[0]);
        }
        return 0.0;
    }

    private double date_to_seconds(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(13);
    }

    private double date_to_minutes(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(12);
    }

    private double date_to_hours(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(11);
    }

    private double date_to_days(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(5);
    }

    private double date_to_months(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(2);
    }

    private double date_to_year(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(1);
    }

    private double date_to_dayofweek(double value) {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone, this.locale);
        calendar.setTime(new Date((long)value));
        return calendar.get(7) - 1;
    }

    @Override
    public int type() {
        return 1;
    }
}

