/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.task.math;

import greycat.internal.task.math.MathToken;

class MathOperation
implements MathToken {
    private String oper;
    private int precedence;
    private boolean leftAssoc;

    MathOperation(String oper, int precedence, boolean leftAssoc) {
        this.oper = oper;
        this.precedence = precedence;
        this.leftAssoc = leftAssoc;
    }

    public String getOper() {
        return this.oper;
    }

    int getPrecedence() {
        return this.precedence;
    }

    boolean isLeftAssoc() {
        return this.leftAssoc;
    }

    double eval(double v1, double v2) {
        if (this.oper.equals("+")) {
            return v1 + v2;
        }
        if (this.oper.equals("-")) {
            return v1 - v2;
        }
        if (this.oper.equals("*")) {
            return v1 * v2;
        }
        if (this.oper.equals("/")) {
            return v1 / v2;
        }
        if (this.oper.equals("%")) {
            return v1 % v2;
        }
        if (this.oper.equals("^")) {
            return Math.pow(v1, v2);
        }
        if (this.oper.equals("&&")) {
            boolean b1 = v1 != 0.0;
            boolean b2 = v2 != 0.0;
            return b1 && b2 ? 1.0 : 0.0;
        }
        if (this.oper.equals("||")) {
            boolean b1 = v1 != 0.0;
            boolean b2 = v2 != 0.0;
            return b1 || b2 ? 1.0 : 0.0;
        }
        if (this.oper.equals(">")) {
            return v1 > v2 ? 1.0 : 0.0;
        }
        if (this.oper.equals(">=")) {
            return v1 >= v2 ? 1.0 : 0.0;
        }
        if (this.oper.equals("<")) {
            return v1 < v2 ? 1.0 : 0.0;
        }
        if (this.oper.equals("<=")) {
            return v1 <= v2 ? 1.0 : 0.0;
        }
        if (this.oper.equals("==")) {
            return v1 == v2 ? 1.0 : 0.0;
        }
        if (this.oper.equals("!=")) {
            return v1 != v2 ? 1.0 : 0.0;
        }
        return 0.0;
    }

    @Override
    public int type() {
        return 0;
    }
}

