/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

public class HRect {
    public double[] min;
    public double[] max;

    public HRect(double[] vmin, double[] vmax) {
        this.min = new double[vmin.length];
        this.max = new double[vmax.length];
        System.arraycopy(vmin, 0, this.min, 0, vmin.length);
        System.arraycopy(vmax, 0, this.max, 0, vmax.length);
    }

    public final Object clone() {
        return new HRect(this.min, this.max);
    }

    public double[] closest(double[] t) {
        double[] p = new double[t.length];
        for (int i = 0; i < t.length; ++i) {
            p[i] = t[i] <= this.min[i] ? this.min[i] : (t[i] >= this.max[i] ? this.max[i] : t[i]);
        }
        return p;
    }

    public static HRect infiniteHRect(int d) {
        double[] vmin = new double[d];
        double[] vmax = new double[d];
        for (int i = 0; i < d; ++i) {
            vmin[i] = Double.NEGATIVE_INFINITY;
            vmax[i] = Double.POSITIVE_INFINITY;
        }
        return new HRect(vmin, vmax);
    }

    public String toString() {
        return this.min + "\n" + this.max + "\n";
    }
}

