/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

import greycat.internal.tree.HRect;
import greycat.internal.tree.VolatileTreeResult;
import greycat.struct.EGraph;
import greycat.struct.ENode;
import greycat.struct.Tree;
import greycat.struct.TreeResult;
import greycat.utility.distance.Distance;
import greycat.utility.distance.Distances;

public class KDTree
implements Tree {
    public static int RESOLUTION = 10;
    public static int DISTANCE = 11;
    private static int E_SUBTREE_NODES = 0;
    private static int E_KEY = 1;
    private static int E_SUM_KEY = 2;
    private static int E_VALUE = 3;
    private static int E_SUBTREE_VALUES = 4;
    private static int E_RIGHT = 5;
    private static int E_LEFT = 6;
    private static int STRATEGY = 12;
    private static int DIM = 13;
    private final EGraph eGraph;

    public KDTree(EGraph eGraph) {
        if (eGraph.root() == null) {
            ENode root = eGraph.newNode();
            eGraph.setRoot(root);
        }
        this.eGraph = eGraph;
    }

    private static boolean checkCreateLevels(double[] key1, double[] key2, double[] resolutions) {
        if (resolutions != null) {
            for (int i = 0; i < key2.length; ++i) {
                if (!(Math.abs(key1[i] - key2[i]) > resolutions[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < key2.length; ++i) {
                if (key1[i] == key2[i]) continue;
                return true;
            }
        }
        return false;
    }

    private static void rangeSearch(double[] lowk, double[] uppk, double[] center, Distance distance, ENode node, int lev, int dim, VolatileTreeResult nnl) {
        int j;
        if (node == null) {
            return;
        }
        double[] key = (double[])node.getAt(E_KEY);
        if (lowk[lev] <= key[lev]) {
            KDTree.rangeSearch(lowk, uppk, center, distance, (ENode)node.getAt(E_LEFT), (lev + 1) % dim, dim, nnl);
        }
        for (j = 0; j < dim && lowk[j] <= key[j] && uppk[j] >= key[j]; ++j) {
        }
        if (j == dim) {
            nnl.insert(key, (Long)node.getAt(E_VALUE), distance.measure(key, center));
        }
        if (uppk[lev] > key[lev]) {
            KDTree.rangeSearch(lowk, uppk, center, distance, (ENode)node.getAt(E_RIGHT), (lev + 1) % dim, dim, nnl);
        }
    }

    private static void recursiveTraverse(ENode node, VolatileTreeResult nnl, Distance distance, double[] target, HRect hr, int lev, int dim, double max_dist_sqd, double radius) {
        HRect further_hr;
        ENode further_kd;
        HRect nearer_hr;
        ENode nearer_kd;
        boolean target_in_left;
        if (node == null) {
            return;
        }
        double[] pivot = (double[])node.getAt(E_KEY);
        if (pivot == null) {
            throw new RuntimeException("Key can't be null");
        }
        int s = lev % dim;
        double pivot_to_target = distance.measure(pivot, target);
        HRect left_hr = hr;
        HRect right_hr = (HRect)hr.clone();
        left_hr.max[s] = pivot[s];
        right_hr.min[s] = pivot[s];
        boolean bl = target_in_left = target[s] < pivot[s];
        if (target_in_left) {
            nearer_kd = (ENode)node.getAt(E_LEFT);
            nearer_hr = left_hr;
            further_kd = (ENode)node.getAt(E_RIGHT);
            further_hr = right_hr;
        } else {
            nearer_kd = (ENode)node.getAt(E_RIGHT);
            nearer_hr = right_hr;
            further_kd = (ENode)node.getAt(E_LEFT);
            further_hr = left_hr;
        }
        KDTree.recursiveTraverse(nearer_kd, nnl, distance, target, nearer_hr, lev + 1, dim, max_dist_sqd, radius);
        double dist_sqd = !nnl.isCapacityReached() ? Double.MAX_VALUE : nnl.getWorstDistance();
        max_dist_sqd = Math.min(max_dist_sqd, dist_sqd);
        double[] closest = further_hr.closest(target);
        if (distance.measure(closest, target) < max_dist_sqd) {
            if (pivot_to_target < dist_sqd) {
                dist_sqd = pivot_to_target;
                if (radius > 0.0) {
                    if (dist_sqd < radius) {
                        nnl.insert(pivot, (Long)node.getAt(E_VALUE), dist_sqd);
                    }
                } else {
                    nnl.insert(pivot, (Long)node.getAt(E_VALUE), dist_sqd);
                }
                max_dist_sqd = nnl.isCapacityReached() ? nnl.getWorstDistance() : Double.MAX_VALUE;
            }
            KDTree.recursiveTraverse(further_kd, nnl, distance, target, further_hr, lev + 1, dim, max_dist_sqd, radius);
        }
    }

    private static boolean internalInsert(ENode node, double[] key, long value, int strategyType, int lev, double[] resolution) {
        ENode child;
        double[] pKey = (double[])node.getAt(E_KEY);
        if (pKey == null) {
            pKey = new double[key.length];
            System.arraycopy(key, 0, pKey, 0, key.length);
            node.setAt(E_KEY, (byte)6, pKey);
            node.setAt(E_VALUE, (byte)3, value);
            if (strategyType == 1) {
                node.setAt(E_SUBTREE_VALUES, (byte)3, value);
                double[] sk = new double[pKey.length];
                for (int i = 0; i < key.length; ++i) {
                    sk[i] = pKey[i] * (double)value;
                }
                node.setAt(E_SUM_KEY, (byte)6, sk);
            }
            node.setAt(E_SUBTREE_NODES, (byte)3, 1);
            return true;
        }
        if (!KDTree.checkCreateLevels(key, pKey, resolution)) {
            if (strategyType == 0) {
                node.setAt(E_VALUE, (byte)3, value);
            } else if (strategyType == 1) {
                double[] sk = (double[])node.getAt(E_SUM_KEY);
                for (int i = 0; i < pKey.length; ++i) {
                    sk[i] = sk[i] + key[i] * (double)value;
                }
                node.setAt(E_SUM_KEY, (byte)6, sk);
                node.setAt(E_VALUE, (byte)3, (Long)node.getOrCreateAt(E_VALUE, (byte)3) + value);
                node.setAt(E_SUBTREE_VALUES, (byte)3, (Long)node.getOrCreateAt(E_SUBTREE_VALUES, (byte)3) + value);
            }
            return false;
        }
        if (key[lev] > pKey[lev]) {
            child = (ENode)node.getAt(E_RIGHT);
            if (child == null) {
                child = KDTree.createNode(node, true);
            }
        } else {
            child = (ENode)node.getAt(E_LEFT);
            if (child == null) {
                child = KDTree.createNode(node, false);
            }
        }
        if (KDTree.internalInsert(child, key, value, strategyType, (lev + 1) % key.length, resolution)) {
            if (strategyType == 1) {
                node.setAt(E_SUBTREE_VALUES, (byte)3, (Long)node.getAt(E_SUBTREE_VALUES) + value);
            }
            node.setAt(E_SUBTREE_NODES, (byte)3, (Long)node.getAt(E_SUBTREE_NODES) + 1L);
            return true;
        }
        if (strategyType == 1) {
            node.setAt(E_SUBTREE_VALUES, (byte)3, (Long)node.getAt(E_SUBTREE_VALUES) + value);
        }
        return false;
    }

    private static ENode createNode(ENode parent, boolean right) {
        ENode child = parent.egraph().newNode();
        if (right) {
            parent.setAt(E_RIGHT, (byte)18, child);
        } else {
            parent.setAt(E_LEFT, (byte)18, child);
        }
        return child;
    }

    @Override
    public final void setDistance(int distanceType) {
        this.eGraph.root().setAt(DISTANCE, (byte)4, distanceType);
    }

    @Override
    public final void setResolution(double[] resolution) {
        this.eGraph.root().setAt(RESOLUTION, (byte)6, resolution);
    }

    @Override
    public final void setMinBound(double[] min) {
    }

    @Override
    public final void setMaxBound(double[] max) {
    }

    @Override
    public final void insert(double[] keys, long value) {
        ENode root = this.eGraph.root();
        int strategy = 0;
        if (root.getAt(E_KEY) == null) {
            root.setAt(STRATEGY, (byte)4, strategy);
            root.setAt(DIM, (byte)4, keys.length);
        } else if (keys.length != (Integer)root.getAt(DIM)) {
            throw new RuntimeException("Keys should always be the same length");
        }
        KDTree.internalInsert(root, keys, value, strategy, 0, (double[])root.getAt(RESOLUTION));
    }

    @Override
    public final TreeResult queryAround(double[] keys, int max) {
        return this.queryBoundedRadius(keys, -1.0, max);
    }

    @Override
    public final TreeResult queryRadius(double[] keys, double radius) {
        return this.queryBoundedRadius(keys, radius, -1);
    }

    @Override
    public final TreeResult queryBoundedRadius(double[] keys, double radius, int max) {
        ENode root = this.eGraph.root();
        if (root.getAt(E_KEY) == null) {
            return null;
        }
        Distance distance = Distances.getDistance(root.getAtWithDefault(DISTANCE, 0), null);
        if (keys.length != ((double[])root.getAt(E_KEY)).length) {
            throw new RuntimeException("Keys are not of the same size");
        }
        EGraph calcZone = this.eGraph.graph().space().newVolatileGraph();
        VolatileTreeResult nnl = new VolatileTreeResult(calcZone.newNode(), max);
        KDTree.recursiveTraverse(root, nnl, distance, keys, HRect.infiniteHRect(keys.length), 0, keys.length, Double.MAX_VALUE, radius);
        nnl.sort(true);
        return nnl;
    }

    @Override
    public final TreeResult queryArea(double[] min, double[] max) {
        ENode root = this.eGraph.root();
        if (root.getAt(E_KEY) == null) {
            return null;
        }
        Distance distance = Distances.getDistance(root.getAtWithDefault(DISTANCE, 0), null);
        double[] center = new double[max.length];
        for (int i = 0; i < center.length; ++i) {
            center[i] = (min[i] + max[i]) / 2.0;
        }
        EGraph calcZone = this.eGraph.graph().space().newVolatileGraph();
        VolatileTreeResult nnl = new VolatileTreeResult(calcZone.newNode(), -1);
        KDTree.rangeSearch(min, max, center, distance, root, 0, min.length, nnl);
        nnl.sort(true);
        return nnl;
    }

    @Override
    public final long size() {
        return (Long)this.eGraph.root().getAt(E_SUBTREE_NODES);
    }

    @Override
    public final long treeSize() {
        return (Long)this.eGraph.root().getAt(E_SUBTREE_NODES);
    }
}

