/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

import greycat.Graph;
import greycat.Node;
import greycat.base.BaseNode;
import greycat.internal.tree.KDTree;
import greycat.struct.Tree;
import greycat.struct.TreeResult;

public class KDTreeNode
extends BaseNode
implements Tree {
    public static String NAME = "KDTreeNode";
    public static String BOUND_MIN = "bound_min";
    public static String BOUND_MAX = "bound_max";
    public static String RESOLUTION = "resolution";
    private static String E_TREE = "etree";
    private KDTree _kdTree = null;

    public KDTreeNode(long p_world, long p_time, long p_id, Graph p_graph) {
        super(p_world, p_time, p_id, p_graph);
    }

    private KDTree getTree() {
        if (this._kdTree == null) {
            this._kdTree = (KDTree)this.getOrCreate(E_TREE, (byte)22);
        }
        return this._kdTree;
    }

    @Override
    public final Node set(String name, byte type, Object value) {
        if (name.equals(BOUND_MIN)) {
            this.setMinBound((double[])value);
        } else if (name.equals(BOUND_MAX)) {
            this.setMaxBound((double[])value);
        } else if (name.equals(RESOLUTION)) {
            this.setResolution((double[])value);
        } else {
            super.set(name, type, value);
        }
        return this;
    }

    @Override
    public final void setDistance(int distanceType) {
        this.getTree().setDistance(distanceType);
    }

    @Override
    public final void setResolution(double[] resolution) {
        this.getTree().setResolution(resolution);
    }

    @Override
    public final void setMinBound(double[] min) {
        this.getTree().setMinBound(min);
    }

    @Override
    public final void setMaxBound(double[] max) {
        this.getTree().setMaxBound(max);
    }

    @Override
    public final void insert(double[] keys, long value) {
        this.getTree().insert(keys, value);
    }

    @Override
    public final TreeResult queryAround(double[] keys, int max) {
        return this.getTree().queryAround(keys, max);
    }

    @Override
    public final TreeResult queryRadius(double[] keys, double radius) {
        return this.getTree().queryRadius(keys, radius);
    }

    @Override
    public final TreeResult queryBoundedRadius(double[] keys, double radius, int max) {
        return this.getTree().queryBoundedRadius(keys, radius, max);
    }

    @Override
    public final TreeResult queryArea(double[] min, double[] max) {
        return this.getTree().queryArea(min, max);
    }

    @Override
    public final long size() {
        return this.getTree().size();
    }

    @Override
    public final long treeSize() {
        return this.getTree().treeSize();
    }
}

