/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

import greycat.internal.tree.TreeHelper;
import greycat.internal.tree.VolatileTreeResult;
import greycat.plugin.NodeStateCallback;
import greycat.struct.DMatrix;
import greycat.struct.EGraph;
import greycat.struct.ENode;
import greycat.struct.LMatrix;
import greycat.struct.Profile;
import greycat.struct.ProfileResult;
import greycat.utility.distance.Distance;
import greycat.utility.distance.Distances;

public class NDTree
implements Profile {
    public static int BUFFER_SIZE_DEF = 20;
    public static int RESOLUTION = 10;
    public static int BUFFER_SIZE = 11;
    public static int DISTANCE = 12;
    private static int STRATEGY = 13;
    private static int E_TOTAL = 0;
    private static int E_SUBNODES = 1;
    private static int E_TOTAL_SUBNODES = 2;
    private static int E_MIN = 3;
    private static int E_MAX = 4;
    private static int E_BUFFER_KEYS = 5;
    private static int E_BUFFER_VALUES = 6;
    private static int E_VALUE = 7;
    private static int E_PROFILE = 8;
    private static int E_OFFSET_REL = 16;
    private final EGraph eGraph;

    public NDTree(EGraph eGraph) {
        this.eGraph = eGraph;
        if (eGraph.root() == null) {
            ENode root = eGraph.newNode();
            eGraph.setRoot(root);
        }
    }

    private static int getRelationId(double[] centerKey, double[] keyToInsert) {
        int result = 0;
        for (int i = 0; i < centerKey.length; ++i) {
            if (i != 0) {
                result <<= 1;
            }
            if (!(keyToInsert[i] > centerKey[i])) continue;
            ++result;
        }
        return result + E_OFFSET_REL;
    }

    private static boolean checkCreateLevels(double[] min, double[] max, double[] resolutions) {
        if (resolutions != null) {
            for (int i = 0; i < min.length; ++i) {
                if (!(max[i] - min[i] > 2.0 * resolutions[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < min.length; ++i) {
                if (!(max[i] > min[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static double[] getCenterMinMax(double[] min, double[] max) {
        double[] center = new double[min.length];
        for (int i = 0; i < min.length; ++i) {
            center[i] = (max[i] + min[i]) / 2.0;
        }
        return center;
    }

    private static double[] getCenter(ENode node) {
        double[] min = (double[])node.getAt(E_MIN);
        double[] max = (double[])node.getAt(E_MAX);
        return NDTree.getCenterMinMax(min, max);
    }

    private static void check(double[] values, double[] min, double[] max) {
        if (min == null || max == null) {
            throw new RuntimeException("Please set min and max boundary before inserting in the trees");
        }
        if (values.length != min.length) {
            throw new RuntimeException("Values dimension mismatch");
        }
        for (int i = 0; i < min.length; ++i) {
            if (!(values[i] < min[i]) && !(values[i] > max[i])) continue;
            throw new RuntimeException("Values should be between min, max!");
        }
    }

    private static ENode createNewNode(ENode parent, ENode root, int index, double[] min, double[] max, double[] center, double[] keyToInsert, int buffersize) {
        ENode node = parent.egraph().newNode();
        double[] minChild = new double[min.length];
        double[] maxChild = new double[max.length];
        for (int i = 0; i < min.length; ++i) {
            if (keyToInsert[i] <= center[i]) {
                minChild[i] = min[i];
                maxChild[i] = center[i];
                continue;
            }
            minChild[i] = center[i];
            maxChild[i] = max[i];
        }
        node.setAt(E_SUBNODES, (byte)3, 0);
        node.setAt(E_MIN, (byte)6, minChild);
        node.setAt(E_MAX, (byte)6, maxChild);
        node.setAt(E_TOTAL, (byte)3, 0);
        root.setAt(E_TOTAL_SUBNODES, (byte)3, (Long)root.getAt(E_TOTAL_SUBNODES) + 1L);
        parent.setAt(E_SUBNODES, (byte)3, (Long)parent.getAt(E_SUBNODES) + 1L);
        parent.setAt(index, (byte)18, node);
        return node;
    }

    private static boolean subInsert(ENode parent, double[] key, long value, int strategyType, double[] min, double[] max, double[] center, double[] resolution, int buffersize, ENode root, boolean bufferupdate) {
        double[] childcenter;
        double[] childmax;
        double[] childmin;
        boolean res;
        int index = NDTree.getRelationId(center, key);
        ENode child = (ENode)parent.getAt(index);
        if (child == null) {
            child = NDTree.createNewNode(parent, root, index, min, max, center, key, buffersize);
        }
        boolean bl = res = (res = NDTree.internalInsert(child, key, value, strategyType, childmin = (double[])child.getAt(E_MIN), childmax = (double[])child.getAt(E_MAX), childcenter = NDTree.getCenterMinMax(childmin, childmax), resolution, buffersize, root)) && !bufferupdate;
        if (res) {
            switch (strategyType) {
                case 1: {
                    parent.setAt(E_TOTAL, (byte)3, (Long)parent.getAt(E_TOTAL) + value);
                    break;
                }
                case 0: {
                    parent.setAt(E_TOTAL, (byte)3, (Long)parent.getAt(E_TOTAL) + 1L);
                    break;
                }
                default: {
                    throw new RuntimeException("Index strategy is wrong!");
                }
            }
        }
        return res;
    }

    private static boolean internalInsert(ENode node, double[] key, long value, int strategyType, double[] min, double[] max, double[] center, double[] resolution, int buffersize, ENode root) {
        if ((Long)node.getAt(E_SUBNODES) != 0L) {
            return NDTree.subInsert(node, key, value, strategyType, min, max, center, resolution, buffersize, root, false);
        }
        if (NDTree.checkCreateLevels(min, max, resolution)) {
            DMatrix buffer = null;
            if (buffersize > 0) {
                buffer = (DMatrix)node.getOrCreateAt(E_BUFFER_KEYS, (byte)15);
            }
            if (buffer != null) {
                for (int i = 0; i < buffer.columns(); ++i) {
                    if (!NDTree.compare(key, buffer.column(i), resolution)) continue;
                    switch (strategyType) {
                        case 1: {
                            DMatrix bufferkeys = (DMatrix)node.getAt(E_PROFILE);
                            for (int j = 0; j < key.length; ++j) {
                                bufferkeys.set(j, i, bufferkeys.get(j, i) + key[j] * (double)value);
                            }
                            LMatrix bufferValue = (LMatrix)node.getAt(E_BUFFER_VALUES);
                            bufferValue.set(0, i, bufferValue.get(0, i) + value);
                            node.setAt(E_TOTAL, (byte)3, (Long)node.getAt(E_TOTAL) + value);
                            return true;
                        }
                        case 0: {
                            LMatrix bufferValue = (LMatrix)node.getAt(E_BUFFER_VALUES);
                            bufferValue.set(0, i, value);
                            return false;
                        }
                    }
                    throw new RuntimeException("Index strategy is wrong!");
                }
                if (buffer.columns() < buffersize) {
                    buffer.appendColumn(key);
                    switch (strategyType) {
                        case 1: {
                            DMatrix bufferkeys = (DMatrix)node.getOrCreateAt(E_PROFILE, (byte)15);
                            bufferkeys.appendColumn(key);
                            LMatrix bufferValue = (LMatrix)node.getOrCreateAt(E_BUFFER_VALUES, (byte)16);
                            bufferValue.appendColumn(new long[]{value});
                            node.setAt(E_TOTAL, (byte)3, (Long)node.getAt(E_TOTAL) + value);
                            return true;
                        }
                        case 0: {
                            LMatrix bufferValue = (LMatrix)node.getOrCreateAt(E_BUFFER_VALUES, (byte)16);
                            bufferValue.appendColumn(new long[]{value});
                            node.setAt(E_TOTAL, (byte)3, (Long)node.getAt(E_TOTAL) + 1L);
                            return true;
                        }
                    }
                    throw new RuntimeException("Index strategy is wrong!");
                }
                if (strategyType == 1) {
                    DMatrix bufferkeys = (DMatrix)node.getAt(E_PROFILE);
                    LMatrix bufferValue = (LMatrix)node.getAt(E_BUFFER_VALUES);
                    for (int i = 0; i < buffer.columns(); ++i) {
                        long t = bufferValue.get(0, i);
                        for (int j = 0; j < buffer.rows(); ++j) {
                            buffer.set(j, i, bufferkeys.get(j, i) / (double)t);
                        }
                    }
                    node.setAt(E_PROFILE, (byte)15, null);
                }
                LMatrix bufferValue = (LMatrix)node.getAt(E_BUFFER_VALUES);
                for (int i = 0; i < buffer.columns(); ++i) {
                    NDTree.subInsert(node, buffer.column(i), bufferValue.get(0, i), strategyType, min, max, center, resolution, buffersize, root, true);
                }
                node.setAt(E_BUFFER_VALUES, (byte)16, null);
                node.setAt(E_BUFFER_KEYS, (byte)15, null);
                return NDTree.subInsert(node, key, value, strategyType, min, max, center, resolution, buffersize, root, false);
            }
            return NDTree.subInsert(node, key, value, strategyType, min, max, center, resolution, buffersize, root, false);
        }
        switch (strategyType) {
            case 1: {
                double[] profile = (double[])node.getAt(E_PROFILE);
                if (profile == null) {
                    profile = new double[key.length];
                    System.arraycopy(key, 0, profile, 0, key.length);
                } else {
                    for (int i = 0; i < key.length; ++i) {
                        int n = i;
                        profile[n] = profile[n] + key[i] * (double)value;
                    }
                }
                node.setAt(E_PROFILE, (byte)6, profile);
                node.setAt(E_TOTAL, (byte)3, (Long)node.getAt(E_TOTAL) + value);
                return true;
            }
            case 0: {
                if ((Long)node.getAt(E_TOTAL) == 0L) {
                    node.setAt(E_PROFILE, (byte)6, key);
                    node.setAt(E_VALUE, (byte)3, value);
                    node.setAt(E_TOTAL, (byte)3, 1);
                    return true;
                }
                node.setAt(E_PROFILE, (byte)6, key);
                node.setAt(E_VALUE, (byte)3, value);
                return false;
            }
        }
        throw new RuntimeException("Index strategy is wrong!");
    }

    private static boolean compare(double[] key1, double[] key2, double[] resolution) {
        if (resolution != null) {
            for (int i = 0; i < key1.length; ++i) {
                if (!(Math.abs(key1[i] - key2[i]) > resolution[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < key1.length; ++i) {
                if (!(Math.abs(key1[i] - key2[i]) > 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setDistance(int distanceType) {
        this.eGraph.root().setAt(DISTANCE, (byte)4, distanceType);
    }

    @Override
    public void setResolution(double[] resolution) {
        this.eGraph.root().setAt(RESOLUTION, (byte)6, resolution);
    }

    @Override
    public void setMinBound(double[] min) {
        this.eGraph.root().setAt(E_MIN, (byte)6, min);
    }

    @Override
    public void setMaxBound(double[] max) {
        this.eGraph.root().setAt(E_MAX, (byte)6, max);
    }

    @Override
    public void setBufferSize(int bufferSize) {
        if (bufferSize < 0) {
            throw new RuntimeException("Buffer size can't be <0");
        }
        this.eGraph.root().setAt(BUFFER_SIZE, (byte)4, bufferSize);
    }

    @Override
    public void insert(double[] keys, long value) {
        ENode root = this.eGraph.root();
        double[] min = (double[])root.getAt(E_MIN);
        double[] max = (double[])root.getAt(E_MAX);
        NDTree.check(keys, min, max);
        double[] resolution = (double[])root.getAt(RESOLUTION);
        int buffersize = root.getAtWithDefault(BUFFER_SIZE, BUFFER_SIZE_DEF);
        if (root.getAtWithDefault(E_TOTAL, 0L) == 0L) {
            root.setAt(STRATEGY, (byte)4, 0);
            root.setAt(E_TOTAL, (byte)3, 0);
            root.setAt(E_TOTAL_SUBNODES, (byte)3, 0);
            root.setAt(E_SUBNODES, (byte)3, 0);
            root.setAt(E_MIN, (byte)6, min);
            root.setAt(E_MAX, (byte)6, max);
        }
        NDTree.internalInsert(root, keys, value, 0, min, max, NDTree.getCenterMinMax(min, max), resolution, buffersize, root);
    }

    @Override
    public void profile(double[] keys) {
        this.profileWith(keys, 1L);
    }

    @Override
    public void profileWith(double[] keys, long occurrence) {
        ENode root = this.eGraph.root();
        double[] min = (double[])root.getAt(E_MIN);
        double[] max = (double[])root.getAt(E_MAX);
        NDTree.check(keys, min, max);
        double[] resolution = (double[])root.getAt(RESOLUTION);
        int buffersize = root.getAtWithDefault(BUFFER_SIZE, BUFFER_SIZE_DEF);
        if (root.getAtWithDefault(E_TOTAL, 0L) == 0L) {
            root.setAt(STRATEGY, (byte)4, 1);
            root.setAt(E_TOTAL, (byte)3, 0);
            root.setAt(E_TOTAL_SUBNODES, (byte)3, 0);
            root.setAt(E_SUBNODES, (byte)3, 0);
            root.setAt(E_MIN, (byte)6, min);
            root.setAt(E_MAX, (byte)6, max);
        }
        NDTree.internalInsert(root, keys, occurrence, 1, min, max, NDTree.getCenterMinMax(min, max), resolution, buffersize, root);
    }

    @Override
    public final ProfileResult queryAround(double[] keys, int max) {
        return this.queryBoundedRadius(keys, -1.0, max);
    }

    @Override
    public final ProfileResult queryRadius(double[] keys, double radius) {
        return this.queryBoundedRadius(keys, radius, -1);
    }

    @Override
    public final ProfileResult queryBoundedRadius(double[] keys, double radius, int max) {
        ENode root = this.eGraph.root();
        if (root.getAtWithDefault(E_TOTAL, 0L) == 0L) {
            return null;
        }
        double[] emin = (double[])root.getAt(E_MIN);
        double[] emax = (double[])root.getAt(E_MAX);
        NDTree.check(keys, emin, emax);
        Distance distance = Distances.getDistance(root.getAtWithDefault(DISTANCE, 0), null);
        int strategyType = (Integer)root.getAt(STRATEGY);
        EGraph calcZone = this.eGraph.graph().space().newVolatileGraph();
        VolatileTreeResult nnl = new VolatileTreeResult(calcZone.newNode(), max);
        NDTree.reccursiveTraverse(root, calcZone, nnl, strategyType, distance, keys, null, null, null, radius);
        nnl.sort(true);
        return nnl;
    }

    @Override
    public final ProfileResult queryArea(double[] min, double[] max) {
        ENode root = this.eGraph.root();
        if (root.getAtWithDefault(E_TOTAL, 0L) == 0L) {
            return null;
        }
        Distance distance = Distances.getDistance(root.getAtWithDefault(DISTANCE, 0), null);
        int strategyType = (Integer)root.getAt(STRATEGY);
        double[] center = new double[max.length];
        for (int i = 0; i < center.length; ++i) {
            center[i] = (min[i] + max[i]) / 2.0;
        }
        EGraph calcZone = this.eGraph.graph().space().newVolatileGraph();
        VolatileTreeResult nnl = new VolatileTreeResult(calcZone.newNode(), -1);
        NDTree.reccursiveTraverse(root, calcZone, nnl, strategyType, distance, null, min, max, center, -1.0);
        nnl.sort(true);
        return nnl;
    }

    @Override
    public long size() {
        ENode root = this.eGraph.root();
        return root.getAtWithDefault(E_TOTAL, 0L);
    }

    @Override
    public long treeSize() {
        ENode root = this.eGraph.root();
        return root.getAtWithDefault(E_TOTAL_SUBNODES, 0L);
    }

    private static boolean[] binaryFromLong(long value, int dim) {
        long tempvalue = value - (long)E_OFFSET_REL;
        long shiftvalue = tempvalue >> 1;
        boolean[] res = new boolean[dim];
        for (int i = 0; i < dim; ++i) {
            res[dim - i - 1] = tempvalue - (shiftvalue << 1) == 1L;
            tempvalue = shiftvalue;
            shiftvalue = tempvalue >> 1;
        }
        return res;
    }

    private static void reccursiveTraverse(final ENode node, final EGraph calcZone, final VolatileTreeResult nnl, final int strategyType, final Distance distance, final double[] target, final double[] targetmin, final double[] targetmax, final double[] targetcenter, final double radius) {
        if (node.getAtWithDefault(E_SUBNODES, 0L) == 0L) {
            DMatrix buffer = (DMatrix)node.getAt(E_BUFFER_KEYS);
            LMatrix bufferValue = (LMatrix)node.getAt(E_BUFFER_VALUES);
            if (buffer != null) {
                switch (strategyType) {
                    case 1: {
                        double[] tempK = new double[target.length];
                        DMatrix bufferkeys = (DMatrix)node.getAt(E_PROFILE);
                        for (int i = 0; i < buffer.columns(); ++i) {
                            long t = bufferValue.get(0, i);
                            for (int j = 0; j < buffer.rows(); ++j) {
                                tempK[j] = bufferkeys.get(j, i) / (double)t;
                            }
                            TreeHelper.filterAndInsert(tempK, t, target, targetmin, targetmax, targetcenter, distance, radius, nnl);
                        }
                        return;
                    }
                    case 0: {
                        for (int i = 0; i < buffer.columns(); ++i) {
                            TreeHelper.filterAndInsert(buffer.column(i), bufferValue.get(0, i), target, targetmin, targetmax, targetcenter, distance, radius, nnl);
                        }
                        return;
                    }
                }
                throw new RuntimeException("Index strategy is wrong!");
            }
            switch (strategyType) {
                case 1: {
                    double[] keyo = (double[])node.getAt(E_PROFILE);
                    double[] key = new double[keyo.length];
                    long value = (Long)node.getAt(E_TOTAL);
                    for (int i = 0; i < keyo.length; ++i) {
                        key[i] = keyo[i] / (double)value;
                    }
                    TreeHelper.filterAndInsert(key, value, target, targetmin, targetmax, targetcenter, distance, radius, nnl);
                    return;
                }
                case 0: {
                    double[] key = (double[])node.getAt(E_PROFILE);
                    long value = (Long)node.getAt(E_VALUE);
                    TreeHelper.filterAndInsert(key, value, target, targetmin, targetmax, targetcenter, distance, radius, nnl);
                    return;
                }
            }
            throw new RuntimeException("Index strategy is wrong!");
        }
        final double[] boundMax = (double[])node.getAt(E_MAX);
        final double[] boundMin = (double[])node.getAt(E_MIN);
        double worst = nnl.getWorstDistance();
        if (targetmin == null || targetmax == null) {
            if (!nnl.isCapacityReached() || TreeHelper.getclosestDistance(target, boundMin, boundMax, distance) <= worst) {
                ENode tempList = calcZone.newNode();
                final VolatileTreeResult childPriority = new VolatileTreeResult(tempList, -1);
                final int dim = boundMax.length;
                final double[] childMin = new double[dim];
                final double[] childMax = new double[dim];
                node.each(new NodeStateCallback(){

                    @Override
                    public void on(int attributeKey, byte elemType, Object elem) {
                        if (attributeKey >= E_OFFSET_REL) {
                            boolean[] binaries = NDTree.binaryFromLong(attributeKey, dim);
                            for (int i = 0; i < dim; ++i) {
                                if (!binaries[i]) {
                                    childMin[i] = boundMin[i];
                                    childMax[i] = (boundMax[i] + boundMin[i]) / 2.0;
                                    continue;
                                }
                                childMin[i] = (boundMax[i] + boundMin[i]) / 2.0;
                                childMax[i] = boundMax[i];
                            }
                            childPriority.insert(childMin, attributeKey, TreeHelper.getclosestDistance(target, childMin, childMax, distance));
                        }
                    }
                });
                childPriority.sort(true);
                for (int i = 0; i < childPriority.size(); ++i) {
                    ENode child = (ENode)node.getAt((int)childPriority.value(i));
                    NDTree.reccursiveTraverse(child, calcZone, nnl, strategyType, distance, target, targetmin, targetmax, targetcenter, radius);
                }
                childPriority.free();
            }
        } else {
            node.each(new NodeStateCallback(){

                @Override
                public void on(int attributeKey, byte elemType, Object elem) {
                    ENode child;
                    if (attributeKey >= E_OFFSET_REL && TreeHelper.checkBoundsIntersection(targetmin, targetmax, (double[])(child = (ENode)node.getAt(attributeKey)).getAt(E_MIN), (double[])child.getAt(E_MAX))) {
                        NDTree.reccursiveTraverse(child, calcZone, nnl, strategyType, distance, target, targetmin, targetmax, targetcenter, radius);
                    }
                }
            });
        }
    }
}

